-- MySQL dump 10.13  Distrib 5.7.40, for Linux (x86_64)
--
-- Host: localhost    Database: linuxele_new
-- ------------------------------------------------------
-- Server version	5.7.40

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `ospos_app_config`
--

DROP TABLE IF EXISTS `ospos_app_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_app_config` (
  `key` varchar(50) NOT NULL,
  `value` varchar(500) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_app_config`
--

LOCK TABLES `ospos_app_config` WRITE;
/*!40000 ALTER TABLE `ospos_app_config` DISABLE KEYS */;
INSERT INTO `ospos_app_config` VALUES ('address','Kathangaita'),('allow_duplicate_barcodes','0'),('barcode_content','id'),('barcode_first_row','category'),('barcode_font','Arial'),('barcode_font_size','10'),('barcode_formats','[]'),('barcode_generate_if_empty','0'),('barcode_height','50'),('barcode_num_in_row','2'),('barcode_page_cellspacing','20'),('barcode_page_width','100'),('barcode_second_row','item_code'),('barcode_third_row','unit_price'),('barcode_type','Code39'),('barcode_width','250'),('cash_decimals','2'),('cash_rounding_code','1'),('company','Linux Electricals '),('company_logo',''),('country_codes','us'),('currency_code','USD'),('currency_decimals','2'),('currency_symbol','Kshs'),('customer_reward_enable','0'),('dateformat','m/d/Y'),('date_or_time_format',''),('default_receivings_discount','0'),('default_receivings_discount_type','0'),('default_register_mode','sale'),('default_sales_discount','0'),('default_sales_discount_type','0'),('default_tax_1_name',''),('default_tax_1_rate',''),('default_tax_2_name',''),('default_tax_2_rate',''),('default_tax_category','Standard'),('default_tax_code',''),('default_tax_jurisdiction',''),('default_tax_rate','8'),('derive_sale_quantity','0'),('dinner_table_enable','0'),('email',''),('email_receipt_check_behaviour','last'),('enforce_privacy','0'),('fax',''),('financial_year','1'),('gcaptcha_enable','0'),('gcaptcha_secret_key',''),('gcaptcha_site_key',''),('giftcard_number','series'),('image_allowed_types','gif|jpg|png'),('image_max_height','480'),('image_max_size','128'),('image_max_width','640'),('include_hsn','0'),('invoice_default_comments','This is a default comment'),('invoice_email_message','Dear {CU}, In attachment the receipt for sale {ISEQ}'),('invoice_enable','1'),('invoice_type','invoice'),('language','english'),('language_code','en-US'),('last_used_invoice_number','0'),('last_used_quote_number','0'),('last_used_work_order_number','0'),('lines_per_page','25'),('line_sequence','0'),('mailpath','/usr/sbin/sendmail'),('msg_msg',''),('msg_pwd',''),('msg_src',''),('msg_uid',''),('multi_pack_enabled','0'),('notify_horizontal_position','center'),('notify_vertical_position','bottom'),('number_locale','en_US'),('payment_options_order','cashdebitcredit'),('phone','0720282377'),('print_bottom_margin','0'),('print_delay_autoreturn','0'),('print_footer','0'),('print_header','0'),('print_left_margin','0'),('print_receipt_check_behaviour','last'),('print_right_margin','0'),('print_silently','1'),('print_top_margin','0'),('protocol','mail'),('quantity_decimals','0'),('quote_default_comments','This is a default quote comment'),('receipt_font_size','12'),('receipt_show_company_name','1'),('receipt_show_description','1'),('receipt_show_serialnumber','1'),('receipt_show_taxes','0'),('receipt_show_tax_ind','0'),('receipt_show_total_discount','1'),('receipt_template','receipt_default'),('receiving_calculate_average_price','0'),('recv_invoice_format','{CO}'),('return_policy','Goods Once Sold are NOT Returnable'),('sales_invoice_format','{CO}'),('sales_quote_format','Q%y{QSEQ:6}'),('smtp_crypto','ssl'),('smtp_host',''),('smtp_pass',''),('smtp_port','465'),('smtp_timeout','5'),('smtp_user',''),('suggestions_first_column','name'),('suggestions_second_column',''),('suggestions_third_column',''),('tax_decimals','2'),('tax_id',''),('tax_included','0'),('theme','flatly'),('thousands_separator','1'),('timeformat','H:i:s'),('timezone','Africa/Addis_Ababa'),('use_destination_based_tax','0'),('website',''),('work_order_enable','0'),('work_order_format','W%y{WSEQ:6}');
/*!40000 ALTER TABLE `ospos_app_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_attribute_definitions`
--

DROP TABLE IF EXISTS `ospos_attribute_definitions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_attribute_definitions` (
  `definition_id` int(10) NOT NULL AUTO_INCREMENT,
  `definition_name` varchar(255) NOT NULL,
  `definition_type` varchar(45) NOT NULL,
  `definition_unit` varchar(16) DEFAULT NULL,
  `definition_flags` tinyint(4) NOT NULL,
  `definition_fk` int(10) DEFAULT NULL,
  `deleted` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`definition_id`),
  KEY `definition_fk` (`definition_fk`),
  CONSTRAINT `fk_ospos_attribute_definitions_ibfk_1` FOREIGN KEY (`definition_fk`) REFERENCES `ospos_attribute_definitions` (`definition_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_attribute_definitions`
--

LOCK TABLES `ospos_attribute_definitions` WRITE;
/*!40000 ALTER TABLE `ospos_attribute_definitions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_attribute_definitions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_attribute_links`
--

DROP TABLE IF EXISTS `ospos_attribute_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_attribute_links` (
  `attribute_id` int(11) DEFAULT NULL,
  `definition_id` int(11) NOT NULL,
  `item_id` int(11) DEFAULT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `receiving_id` int(11) DEFAULT NULL,
  UNIQUE KEY `attribute_links_uq1` (`attribute_id`,`definition_id`,`item_id`,`sale_id`,`receiving_id`),
  KEY `attribute_id` (`attribute_id`),
  KEY `definition_id` (`definition_id`),
  KEY `item_id` (`item_id`),
  KEY `sale_id` (`sale_id`),
  KEY `receiving_id` (`receiving_id`),
  CONSTRAINT `ospos_attribute_links_ibfk_1` FOREIGN KEY (`definition_id`) REFERENCES `ospos_attribute_definitions` (`definition_id`) ON DELETE CASCADE,
  CONSTRAINT `ospos_attribute_links_ibfk_2` FOREIGN KEY (`attribute_id`) REFERENCES `ospos_attribute_values` (`attribute_id`) ON DELETE CASCADE,
  CONSTRAINT `ospos_attribute_links_ibfk_3` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`),
  CONSTRAINT `ospos_attribute_links_ibfk_4` FOREIGN KEY (`receiving_id`) REFERENCES `ospos_receivings` (`receiving_id`) ON DELETE CASCADE,
  CONSTRAINT `ospos_attribute_links_ibfk_5` FOREIGN KEY (`sale_id`) REFERENCES `ospos_sales` (`sale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_attribute_links`
--

LOCK TABLES `ospos_attribute_links` WRITE;
/*!40000 ALTER TABLE `ospos_attribute_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_attribute_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_attribute_values`
--

DROP TABLE IF EXISTS `ospos_attribute_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_attribute_values` (
  `attribute_id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_value` varchar(255) DEFAULT NULL,
  `attribute_date` date DEFAULT NULL,
  `attribute_decimal` decimal(7,3) DEFAULT NULL,
  PRIMARY KEY (`attribute_id`),
  UNIQUE KEY `attribute_value` (`attribute_value`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_attribute_values`
--

LOCK TABLES `ospos_attribute_values` WRITE;
/*!40000 ALTER TABLE `ospos_attribute_values` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_attribute_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_cash_up`
--

DROP TABLE IF EXISTS `ospos_cash_up`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_cash_up` (
  `cashup_id` int(10) NOT NULL AUTO_INCREMENT,
  `open_date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `close_date` timestamp NULL DEFAULT NULL,
  `open_amount_cash` decimal(15,2) NOT NULL,
  `transfer_amount_cash` decimal(15,2) NOT NULL,
  `note` int(1) NOT NULL,
  `closed_amount_cash` decimal(15,2) NOT NULL,
  `closed_amount_card` decimal(15,2) NOT NULL,
  `closed_amount_check` decimal(15,2) NOT NULL,
  `closed_amount_total` decimal(15,2) NOT NULL,
  `description` varchar(255) NOT NULL,
  `open_employee_id` int(10) NOT NULL,
  `close_employee_id` int(10) NOT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  `closed_amount_due` decimal(15,2) NOT NULL,
  PRIMARY KEY (`cashup_id`),
  KEY `open_employee_id` (`open_employee_id`),
  KEY `close_employee_id` (`close_employee_id`),
  CONSTRAINT `ospos_cash_up_ibfk_1` FOREIGN KEY (`open_employee_id`) REFERENCES `ospos_employees` (`person_id`),
  CONSTRAINT `ospos_cash_up_ibfk_2` FOREIGN KEY (`close_employee_id`) REFERENCES `ospos_employees` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_cash_up`
--

LOCK TABLES `ospos_cash_up` WRITE;
/*!40000 ALTER TABLE `ospos_cash_up` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_cash_up` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_customers`
--

DROP TABLE IF EXISTS `ospos_customers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_customers` (
  `person_id` int(10) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `account_number` varchar(255) DEFAULT NULL,
  `taxable` int(1) NOT NULL DEFAULT '1',
  `tax_id` varchar(32) NOT NULL DEFAULT '',
  `sales_tax_code_id` int(11) DEFAULT NULL,
  `discount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_type` tinyint(2) NOT NULL DEFAULT '0',
  `package_id` int(11) DEFAULT NULL,
  `points` int(11) DEFAULT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `employee_id` int(10) NOT NULL,
  `consent` int(1) NOT NULL DEFAULT '0',
  UNIQUE KEY `account_number` (`account_number`),
  KEY `person_id` (`person_id`),
  KEY `package_id` (`package_id`),
  KEY `sales_tax_code_id` (`sales_tax_code_id`),
  CONSTRAINT `ospos_customers_ibfk_1` FOREIGN KEY (`person_id`) REFERENCES `ospos_people` (`person_id`),
  CONSTRAINT `ospos_customers_ibfk_2` FOREIGN KEY (`package_id`) REFERENCES `ospos_customers_packages` (`package_id`),
  CONSTRAINT `ospos_customers_ibfk_3` FOREIGN KEY (`sales_tax_code_id`) REFERENCES `ospos_tax_codes` (`tax_code_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_customers`
--

LOCK TABLES `ospos_customers` WRITE;
/*!40000 ALTER TABLE `ospos_customers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_customers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_customers_packages`
--

DROP TABLE IF EXISTS `ospos_customers_packages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_customers_packages` (
  `package_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_name` varchar(255) DEFAULT NULL,
  `points_percent` float NOT NULL DEFAULT '0',
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`package_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_customers_packages`
--

LOCK TABLES `ospos_customers_packages` WRITE;
/*!40000 ALTER TABLE `ospos_customers_packages` DISABLE KEYS */;
INSERT INTO `ospos_customers_packages` VALUES (1,'Default',0,0),(2,'Bronze',10,0),(3,'Silver',20,0),(4,'Gold',30,0),(5,'Premium',50,0);
/*!40000 ALTER TABLE `ospos_customers_packages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_customers_points`
--

DROP TABLE IF EXISTS `ospos_customers_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_customers_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `person_id` int(11) NOT NULL,
  `package_id` int(11) NOT NULL,
  `sale_id` int(11) NOT NULL,
  `points_earned` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `person_id` (`person_id`),
  KEY `package_id` (`package_id`),
  KEY `sale_id` (`sale_id`),
  CONSTRAINT `ospos_customers_points_ibfk_1` FOREIGN KEY (`person_id`) REFERENCES `ospos_customers` (`person_id`),
  CONSTRAINT `ospos_customers_points_ibfk_2` FOREIGN KEY (`package_id`) REFERENCES `ospos_customers_packages` (`package_id`),
  CONSTRAINT `ospos_customers_points_ibfk_3` FOREIGN KEY (`sale_id`) REFERENCES `ospos_sales` (`sale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_customers_points`
--

LOCK TABLES `ospos_customers_points` WRITE;
/*!40000 ALTER TABLE `ospos_customers_points` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_customers_points` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_dinner_tables`
--

DROP TABLE IF EXISTS `ospos_dinner_tables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_dinner_tables` (
  `dinner_table_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`dinner_table_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_dinner_tables`
--

LOCK TABLES `ospos_dinner_tables` WRITE;
/*!40000 ALTER TABLE `ospos_dinner_tables` DISABLE KEYS */;
INSERT INTO `ospos_dinner_tables` VALUES (1,'Delivery',0,0),(2,'Take Away',0,0);
/*!40000 ALTER TABLE `ospos_dinner_tables` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_employees`
--

DROP TABLE IF EXISTS `ospos_employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_employees` (
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `person_id` int(10) NOT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  `hash_version` int(1) NOT NULL DEFAULT '2',
  `language` varchar(48) DEFAULT NULL,
  `language_code` varchar(8) DEFAULT NULL,
  UNIQUE KEY `username` (`username`),
  KEY `person_id` (`person_id`),
  CONSTRAINT `ospos_employees_ibfk_1` FOREIGN KEY (`person_id`) REFERENCES `ospos_people` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_employees`
--

LOCK TABLES `ospos_employees` WRITE;
/*!40000 ALTER TABLE `ospos_employees` DISABLE KEYS */;
INSERT INTO `ospos_employees` VALUES ('betty','$2y$10$.s0rzquhYZ6e88ua3fX7d.m7sQDzfFKu0DvnlE0wgJ6MH5nxRvchm',1,0,2,'',''),('maggy','$2y$10$IaQg0ntkIjWNCmauWFcxuu00Gl4JuD2nU1lrO5Mu3NZ34Wot8mkcW',2,0,2,'','');
/*!40000 ALTER TABLE `ospos_employees` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_expense_categories`
--

DROP TABLE IF EXISTS `ospos_expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_expense_categories` (
  `expense_category_id` int(10) NOT NULL AUTO_INCREMENT,
  `category_name` varchar(255) DEFAULT NULL,
  `category_description` varchar(255) NOT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`expense_category_id`),
  UNIQUE KEY `category_name` (`category_name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_expense_categories`
--

LOCK TABLES `ospos_expense_categories` WRITE;
/*!40000 ALTER TABLE `ospos_expense_categories` DISABLE KEYS */;
INSERT INTO `ospos_expense_categories` VALUES (1,'misc','',0);
/*!40000 ALTER TABLE `ospos_expense_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_expenses`
--

DROP TABLE IF EXISTS `ospos_expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_expenses` (
  `expense_id` int(10) NOT NULL AUTO_INCREMENT,
  `date` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `amount` decimal(15,2) NOT NULL,
  `payment_type` varchar(40) NOT NULL,
  `expense_category_id` int(11) NOT NULL,
  `description` varchar(255) NOT NULL,
  `employee_id` int(10) NOT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  `supplier_tax_code` varchar(255) DEFAULT NULL,
  `tax_amount` decimal(15,2) DEFAULT NULL,
  `supplier_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`expense_id`),
  KEY `expense_category_id` (`expense_category_id`),
  KEY `employee_id` (`employee_id`),
  KEY `ospos_expenses_ibfk_3` (`supplier_id`),
  KEY `date` (`date`),
  CONSTRAINT `ospos_expenses_ibfk_1` FOREIGN KEY (`expense_category_id`) REFERENCES `ospos_expense_categories` (`expense_category_id`),
  CONSTRAINT `ospos_expenses_ibfk_2` FOREIGN KEY (`employee_id`) REFERENCES `ospos_employees` (`person_id`),
  CONSTRAINT `ospos_expenses_ibfk_3` FOREIGN KEY (`supplier_id`) REFERENCES `ospos_suppliers` (`person_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_expenses`
--

LOCK TABLES `ospos_expenses` WRITE;
/*!40000 ALTER TABLE `ospos_expenses` DISABLE KEYS */;
INSERT INTO `ospos_expenses` VALUES (1,'2022-10-30 10:54:41',50.00,'Cash',1,'',2,0,'',0.00,NULL);
/*!40000 ALTER TABLE `ospos_expenses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_giftcards`
--

DROP TABLE IF EXISTS `ospos_giftcards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_giftcards` (
  `record_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `giftcard_id` int(11) NOT NULL AUTO_INCREMENT,
  `giftcard_number` varchar(255) DEFAULT NULL,
  `value` decimal(15,2) NOT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  `person_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`giftcard_id`),
  UNIQUE KEY `giftcard_number` (`giftcard_number`),
  KEY `person_id` (`person_id`),
  CONSTRAINT `ospos_giftcards_ibfk_1` FOREIGN KEY (`person_id`) REFERENCES `ospos_people` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_giftcards`
--

LOCK TABLES `ospos_giftcards` WRITE;
/*!40000 ALTER TABLE `ospos_giftcards` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_giftcards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_grants`
--

DROP TABLE IF EXISTS `ospos_grants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_grants` (
  `permission_id` varchar(255) NOT NULL,
  `person_id` int(10) NOT NULL,
  `menu_group` varchar(32) DEFAULT 'home',
  PRIMARY KEY (`permission_id`,`person_id`),
  KEY `ospos_grants_ibfk_2` (`person_id`),
  CONSTRAINT `ospos_grants_ibfk_1` FOREIGN KEY (`permission_id`) REFERENCES `ospos_permissions` (`permission_id`) ON DELETE CASCADE,
  CONSTRAINT `ospos_grants_ibfk_2` FOREIGN KEY (`person_id`) REFERENCES `ospos_employees` (`person_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_grants`
--

LOCK TABLES `ospos_grants` WRITE;
/*!40000 ALTER TABLE `ospos_grants` DISABLE KEYS */;
INSERT INTO `ospos_grants` VALUES ('attributes',1,'office'),('cashups',1,'home'),('cashups',2,'home'),('config',1,'office'),('customers',1,'home'),('customers',2,'home'),('employees',1,'office'),('expenses',1,'home'),('expenses',2,'home'),('expenses_categories',1,'home'),('expenses_categories',2,'home'),('giftcards',1,'home'),('home',1,'office'),('home',2,'home'),('items',1,'home'),('items',2,'home'),('items_Kathangaita',1,'--'),('items_Kathangaita',2,'--'),('item_kits',1,'home'),('messages',1,'home'),('office',1,'home'),('receivings',1,'home'),('receivings',2,'home'),('receivings_Kathangaita',1,'--'),('receivings_Kathangaita',2,'--'),('reports',1,'home'),('reports',2,'home'),('reports_categories',1,'--'),('reports_customers',1,'--'),('reports_discounts',1,'--'),('reports_employees',1,'--'),('reports_expenses_categories',1,'--'),('reports_inventory',1,'--'),('reports_items',1,'--'),('reports_payments',1,'--'),('reports_receivings',1,'--'),('reports_sales',1,'--'),('reports_sales',2,'--'),('reports_sales_taxes',1,'--'),('reports_suppliers',1,'--'),('reports_taxes',1,'--'),('sales',1,'home'),('sales',2,'home'),('sales_change_price',1,'--'),('sales_change_price',2,'--'),('sales_delete',1,'--'),('sales_Kathangaita',1,'--'),('sales_Kathangaita',2,'--'),('suppliers',1,'home'),('taxes',1,'office');
/*!40000 ALTER TABLE `ospos_grants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_inventory`
--

DROP TABLE IF EXISTS `ospos_inventory`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_inventory` (
  `trans_id` int(11) NOT NULL AUTO_INCREMENT,
  `trans_items` int(11) NOT NULL DEFAULT '0',
  `trans_user` int(11) NOT NULL DEFAULT '0',
  `trans_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `trans_comment` text NOT NULL,
  `trans_location` int(11) NOT NULL,
  `trans_inventory` decimal(15,3) NOT NULL DEFAULT '0.000',
  PRIMARY KEY (`trans_id`),
  KEY `trans_items` (`trans_items`),
  KEY `trans_user` (`trans_user`),
  KEY `trans_location` (`trans_location`),
  KEY `trans_date` (`trans_date`),
  CONSTRAINT `ospos_inventory_ibfk_1` FOREIGN KEY (`trans_items`) REFERENCES `ospos_items` (`item_id`),
  CONSTRAINT `ospos_inventory_ibfk_2` FOREIGN KEY (`trans_user`) REFERENCES `ospos_employees` (`person_id`),
  CONSTRAINT `ospos_inventory_ibfk_3` FOREIGN KEY (`trans_location`) REFERENCES `ospos_stock_locations` (`location_id`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_inventory`
--

LOCK TABLES `ospos_inventory` WRITE;
/*!40000 ALTER TABLE `ospos_inventory` DISABLE KEYS */;
INSERT INTO `ospos_inventory` VALUES (1,1,2,'2022-10-30 03:19:23','Manual Edit of Quantity',1,0.000),(2,1,2,'2022-10-30 03:19:51','',1,9.000),(3,1,2,'2022-10-30 03:21:16','POS 1',1,-1.000),(4,2,2,'2022-10-30 10:28:53','Manual Edit of Quantity',1,1.000),(5,2,2,'2022-10-30 10:29:52','RECV 1',1,1.000),(6,2,2,'2022-10-30 10:30:49','POS 2',1,-1.000),(7,2,2,'2022-10-30 10:35:38','RECV 2',1,2.000),(8,2,2,'2022-10-30 10:35:54','',1,-2.000),(9,1,2,'2022-10-30 10:36:02','',1,1.000),(10,2,2,'2022-10-30 10:39:35','RECV 3',1,10.000),(11,2,2,'2022-10-30 10:45:59','POS 3',1,-1.000),(12,2,2,'2022-10-30 10:56:08','',1,-9.000),(13,3,2,'2022-10-30 11:24:17','Manual Edit of Quantity',1,8.000),(14,4,2,'2022-10-30 11:29:50','Manual Edit of Quantity',1,14.000),(15,5,2,'2022-10-30 11:35:44','Manual Edit of Quantity',1,1.000),(16,6,2,'2022-10-30 11:36:33','Manual Edit of Quantity',1,13.000),(17,7,2,'2022-10-30 11:45:38','Manual Edit of Quantity',1,1.000),(18,8,2,'2022-10-30 11:46:39','Manual Edit of Quantity',1,1.000),(19,9,2,'2022-10-30 11:51:27','Manual Edit of Quantity',1,1.000),(20,10,2,'2022-10-30 11:57:38','Manual Edit of Quantity',1,1.000),(21,11,2,'2022-10-30 11:59:42','Manual Edit of Quantity',1,1.000),(22,12,2,'2022-10-30 12:11:37','Manual Edit of Quantity',1,8.000),(23,13,2,'2022-10-30 12:25:42','Manual Edit of Quantity',1,9.000),(24,14,2,'2022-10-30 12:25:49','Manual Edit of Quantity',1,9.000),(25,14,2,'2022-10-30 09:26:15','Deleted',1,-9.000),(26,15,2,'2022-10-30 12:26:39','Manual Edit of Quantity',1,9.000),(27,16,2,'2022-10-30 12:33:36','Manual Edit of Quantity',1,2.000),(28,17,2,'2022-10-30 12:36:26','Manual Edit of Quantity',1,2.000),(29,18,2,'2022-10-30 12:37:54','Manual Edit of Quantity',1,1.000),(30,19,2,'2022-10-30 12:39:40','Manual Edit of Quantity',1,1.000),(31,20,2,'2022-10-30 12:40:33','Manual Edit of Quantity',1,1.000),(32,21,2,'2022-10-30 12:41:34','Manual Edit of Quantity',1,3.000),(33,22,2,'2022-10-30 12:42:40','Manual Edit of Quantity',1,1.000),(34,23,2,'2022-10-30 12:43:54','Manual Edit of Quantity',1,0.000),(35,24,2,'2022-10-30 13:08:31','Manual Edit of Quantity',1,1.000),(36,25,2,'2022-10-30 13:09:57','Manual Edit of Quantity',1,0.000),(37,26,2,'2022-10-30 13:14:20','Manual Edit of Quantity',1,3.000),(38,27,2,'2022-10-30 13:37:34','Manual Edit of Quantity',1,7.000),(39,28,2,'2022-10-30 13:43:28','Manual Edit of Quantity',1,4.000),(40,29,2,'2022-10-30 13:54:08','Manual Edit of Quantity',1,0.000),(41,29,2,'2022-10-30 13:56:03','Manual Edit of Quantity',1,11.000),(42,30,2,'2022-10-30 14:17:43','Manual Edit of Quantity',1,1.000),(43,31,2,'2022-10-30 14:20:10','Manual Edit of Quantity',1,1.000),(44,32,2,'2022-10-30 14:29:42','Manual Edit of Quantity',1,2.000),(45,33,2,'2022-10-30 15:40:54','Manual Edit of Quantity',1,14.000),(46,34,2,'2022-10-30 15:46:28','Manual Edit of Quantity',1,0.000),(47,34,2,'2022-10-30 15:46:47','Manual Edit of Quantity',1,10.000),(48,35,2,'2022-10-30 15:48:02','Manual Edit of Quantity',1,5.000),(49,36,2,'2022-10-30 15:49:36','Manual Edit of Quantity',1,19.000),(50,37,2,'2022-10-30 16:00:22','Manual Edit of Quantity',1,29.000),(51,38,2,'2022-10-30 16:01:10','Manual Edit of Quantity',1,9.000),(52,39,2,'2022-10-30 16:01:55','Manual Edit of Quantity',1,7.000),(53,40,2,'2022-10-30 16:02:39','Manual Edit of Quantity',1,10.000),(54,41,2,'2022-10-30 16:07:35','Manual Edit of Quantity',1,2.000),(55,42,2,'2022-10-30 16:09:46','Manual Edit of Quantity',1,1.000),(56,42,2,'2022-10-30 16:13:13','Manual Edit of Quantity',1,99.000),(57,41,2,'2022-10-30 16:13:33','Manual Edit of Quantity',1,198.000),(58,43,2,'2022-10-30 16:14:58','Manual Edit of Quantity',1,200.000),(59,44,2,'2022-10-30 16:15:54','Manual Edit of Quantity',1,100.000),(60,45,2,'2022-10-30 16:17:49','Manual Edit of Quantity',1,100.000),(61,46,2,'2022-10-30 16:21:37','Manual Edit of Quantity',1,13.000),(62,47,2,'2022-10-30 16:24:05','Manual Edit of Quantity',1,9.000),(63,48,2,'2022-10-30 16:28:19','Manual Edit of Quantity',1,1.000),(64,9,1,'2022-10-30 19:45:22','POS 4',1,-1.000),(65,7,1,'2022-10-30 19:48:22','POS 5',1,-1.000),(66,4,1,'2022-10-30 19:57:51','POS 6',1,-1.000),(67,1,1,'2022-10-30 20:10:11','Deleting sale 1',1,1.000),(68,2,1,'2022-10-30 20:22:19','Deleting sale 2',1,1.000),(69,2,1,'2022-10-30 20:22:29','Deleting sale 3',1,1.000);
/*!40000 ALTER TABLE `ospos_inventory` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_item_kit_items`
--

DROP TABLE IF EXISTS `ospos_item_kit_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_item_kit_items` (
  `item_kit_id` int(11) NOT NULL,
  `item_id` int(11) NOT NULL,
  `quantity` decimal(15,3) NOT NULL,
  `kit_sequence` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`item_kit_id`,`item_id`,`quantity`),
  KEY `ospos_item_kit_items_ibfk_2` (`item_id`),
  CONSTRAINT `ospos_item_kit_items_ibfk_1` FOREIGN KEY (`item_kit_id`) REFERENCES `ospos_item_kits` (`item_kit_id`) ON DELETE CASCADE,
  CONSTRAINT `ospos_item_kit_items_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_item_kit_items`
--

LOCK TABLES `ospos_item_kit_items` WRITE;
/*!40000 ALTER TABLE `ospos_item_kit_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_item_kit_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_item_kits`
--

DROP TABLE IF EXISTS `ospos_item_kits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_item_kits` (
  `item_kit_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `item_id` int(10) NOT NULL DEFAULT '0',
  `kit_discount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `kit_discount_type` tinyint(2) NOT NULL DEFAULT '0',
  `price_option` tinyint(2) NOT NULL DEFAULT '0',
  `print_option` tinyint(2) NOT NULL DEFAULT '0',
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`item_kit_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_item_kits`
--

LOCK TABLES `ospos_item_kits` WRITE;
/*!40000 ALTER TABLE `ospos_item_kits` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_item_kits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_item_quantities`
--

DROP TABLE IF EXISTS `ospos_item_quantities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_item_quantities` (
  `item_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  `quantity` decimal(15,3) NOT NULL DEFAULT '0.000',
  PRIMARY KEY (`item_id`,`location_id`),
  KEY `item_id` (`item_id`),
  KEY `location_id` (`location_id`),
  CONSTRAINT `ospos_item_quantities_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`),
  CONSTRAINT `ospos_item_quantities_ibfk_2` FOREIGN KEY (`location_id`) REFERENCES `ospos_stock_locations` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_item_quantities`
--

LOCK TABLES `ospos_item_quantities` WRITE;
/*!40000 ALTER TABLE `ospos_item_quantities` DISABLE KEYS */;
INSERT INTO `ospos_item_quantities` VALUES (1,1,10.000),(2,1,3.000),(3,1,8.000),(4,1,13.000),(5,1,1.000),(6,1,13.000),(7,1,0.000),(8,1,1.000),(9,1,0.000),(10,1,1.000),(11,1,1.000),(12,1,8.000),(13,1,9.000),(14,1,0.000),(15,1,9.000),(16,1,2.000),(17,1,2.000),(18,1,1.000),(19,1,1.000),(20,1,1.000),(21,1,3.000),(22,1,1.000),(23,1,0.000),(24,1,1.000),(25,1,0.000),(26,1,3.000),(27,1,7.000),(28,1,4.000),(29,1,11.000),(30,1,1.000),(31,1,1.000),(32,1,2.000),(33,1,14.000),(34,1,10.000),(35,1,5.000),(36,1,19.000),(37,1,29.000),(38,1,9.000),(39,1,7.000),(40,1,10.000),(41,1,200.000),(42,1,100.000),(43,1,200.000),(44,1,100.000),(45,1,100.000),(46,1,13.000),(47,1,9.000),(48,1,1.000);
/*!40000 ALTER TABLE `ospos_item_quantities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_items`
--

DROP TABLE IF EXISTS `ospos_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_items` (
  `name` varchar(255) NOT NULL,
  `category` varchar(255) NOT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `item_number` varchar(255) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `cost_price` decimal(15,2) NOT NULL,
  `unit_price` decimal(15,2) NOT NULL,
  `reorder_level` decimal(15,3) NOT NULL DEFAULT '0.000',
  `receiving_quantity` decimal(15,3) NOT NULL DEFAULT '1.000',
  `item_id` int(10) NOT NULL AUTO_INCREMENT,
  `pic_filename` varchar(255) DEFAULT NULL,
  `allow_alt_description` tinyint(1) NOT NULL,
  `is_serialized` tinyint(1) NOT NULL,
  `stock_type` tinyint(2) NOT NULL DEFAULT '0',
  `item_type` tinyint(2) NOT NULL DEFAULT '0',
  `deleted` int(1) NOT NULL DEFAULT '0',
  `tax_category_id` int(10) DEFAULT NULL,
  `qty_per_pack` decimal(15,3) NOT NULL DEFAULT '1.000',
  `pack_name` varchar(8) DEFAULT 'Each',
  `low_sell_item_id` int(10) DEFAULT '0',
  `hsn_code` varchar(32) NOT NULL DEFAULT '',
  PRIMARY KEY (`item_id`),
  KEY `item_number` (`item_number`),
  KEY `supplier_id` (`supplier_id`),
  CONSTRAINT `ospos_items_ibfk_1` FOREIGN KEY (`supplier_id`) REFERENCES `ospos_suppliers` (`person_id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_items`
--

LOCK TABLES `ospos_items` WRITE;
/*!40000 ALTER TABLE `ospos_items` DISABLE KEYS */;
INSERT INTO `ospos_items` VALUES ('4 G Power  Travel Charger','Elec',NULL,NULL,'',60.00,100.00,1.000,1.000,1,NULL,0,0,0,0,0,0,1.000,'Each',1,''),('3 G Travel Charger','Elec',NULL,NULL,'',60.00,100.00,1.000,1.000,2,NULL,0,0,0,0,0,0,1.000,'Each',2,''),('Liugel superglue','Elec',NULL,NULL,'',15.00,50.00,1.000,1.000,3,NULL,0,0,0,0,0,0,1.000,'Each',3,''),('Alteco superglue','Elec',NULL,NULL,'',25.00,40.00,1.000,1.000,4,NULL,0,0,0,0,0,0,1.000,'Each',4,''),('Big Scissors','Elec',NULL,NULL,'',150.00,250.00,1.000,1.000,5,NULL,0,0,0,0,0,0,1.000,'Each',5,''),('Sparko Superglue','Elec',NULL,NULL,'',25.00,40.00,1.000,1.000,6,NULL,0,0,0,0,0,0,1.000,'Each',6,''),('shower Lorenzetti Maxi Ducha ','elec',NULL,NULL,'',850.00,1500.00,1.000,1.000,7,NULL,0,0,0,0,0,0,1.000,'Each',7,''),('Fame Super Ducha small','Elec',NULL,NULL,'',900.00,1700.00,1.000,1.000,8,NULL,0,0,0,0,0,0,1.000,'Each',8,''),('Horizon shower','elec',NULL,NULL,'',850.00,1500.00,1.000,1.000,9,NULL,0,0,0,0,0,0,1.000,'Each',9,''),('Shower Fame Super Ducha Big','elec',NULL,NULL,'',1300.00,1900.00,1.000,1.000,10,NULL,0,0,0,0,0,0,1.000,'Each',10,''),('Shower HG','Elec',NULL,NULL,'',850.00,1500.00,1.000,1.000,11,NULL,0,0,0,0,0,0,1.000,'Each',11,''),('BULB DC  3WATTS COMPLETE','ElecCT',NULL,NULL,'',75.00,15.00,1.000,1.000,12,NULL,0,0,0,0,0,0,1.000,'Each',12,''),('Bulb dc 5wts complete','elec',NULL,NULL,'',80.00,200.00,1.000,1.000,13,NULL,0,0,0,0,0,0,1.000,'Each',13,''),('Bulb dc 5wts complete','elec',NULL,NULL,'',80.00,200.00,1.000,1.000,14,NULL,0,0,0,0,1,0,1.000,'Each',14,''),('Bulb dc 5wts complete','elec',NULL,NULL,'',80.00,200.00,1.000,1.000,15,NULL,0,0,0,0,0,0,1.000,'Each',15,''),('RCA 5M 2*1','Elec',NULL,NULL,'',200.00,300.00,1.000,1.000,16,NULL,0,0,0,0,0,0,1.000,'Each',16,''),('RCA 10M 2*1','Elec',NULL,NULL,'',300.00,500.00,1.000,1.000,17,NULL,0,0,0,0,0,0,1.000,'Each',17,''),('RCA 3M 2* 1','Elec',NULL,NULL,'',150.00,250.00,1.000,1.000,18,NULL,0,0,0,0,0,0,1.000,'Each',18,''),('HDMI 3M ','ELEC',NULL,NULL,'',200.00,400.00,1.000,1.000,19,NULL,0,0,0,0,0,0,1.000,'Each',19,''),('HDMI 5M','Elec',NULL,NULL,'',300.00,500.00,1.000,1.000,20,NULL,0,0,0,0,0,0,1.000,'Each',20,''),('HDMI 2M','Elec',NULL,NULL,'',100.00,200.00,1.000,1.000,21,NULL,0,0,0,0,0,0,1.000,'Each',21,''),('HDMI 2M 3D','Elec',NULL,NULL,'',300.00,500.00,1.000,1.000,22,NULL,0,0,0,0,0,0,1.000,'Each',22,''),('HDMI 3M 3D','Elec',NULL,NULL,'',300.00,600.00,1.000,1.000,23,NULL,0,0,0,0,1,0,1.000,'Each',23,''),('HDMI 3M 3D','Elec',NULL,NULL,'',300.00,600.00,1.000,1.000,24,NULL,0,0,0,0,0,0,1.000,'Each',24,''),('VGA CABLE','Elec',NULL,NULL,'',120.00,200.00,1.000,1.000,25,NULL,0,0,0,0,1,0,1.000,'Each',25,''),('VGA CABLE','Elec',NULL,NULL,'',120.00,200.00,1.000,1.000,26,NULL,0,0,0,0,0,0,1.000,'Each',26,''),('BATTERY CLIPS','Elec',NULL,NULL,'',50.00,100.00,1.000,1.000,27,NULL,0,0,0,0,0,0,1.000,'Each',27,''),('ELEMENT LORENZETTI','Elec',NULL,NULL,'',100.00,250.00,1.000,1.000,28,NULL,0,0,0,0,0,0,1.000,'Each',28,''),('ELEMENT HORIZON','Elec',NULL,NULL,'',100.00,250.00,1.000,1.000,29,NULL,0,0,0,0,0,0,1.000,'Each',29,''),('ELEMENT H>G','Elec',NULL,NULL,'',300.00,500.00,1.000,1.000,30,NULL,0,0,0,0,0,0,1.000,'Each',30,''),('ELEMENT FAME','Elec',NULL,NULL,'',350.00,500.00,1.000,1.000,31,NULL,0,0,0,0,0,0,1.000,'Each',31,''),('ELEMENT ENERBRAS','Elec',NULL,NULL,'',700.00,950.00,1.000,1.000,32,NULL,0,0,0,0,0,0,1.000,'Each',32,''),('LITHIUM BATTERY CR2032','Elec',NULL,NULL,'',12.00,50.00,1.000,1.000,33,NULL,0,0,0,0,0,0,1.000,'Each',33,''),('LITHIUM BATTERY CR1632','Elec',NULL,NULL,'',12.00,50.00,1.000,1.000,34,NULL,0,0,0,0,0,0,1.000,'Each',34,''),('LITHIUM BATTERY CR1616','Elec',NULL,NULL,'',12.00,50.00,1.000,1.000,35,NULL,0,0,0,0,0,0,1.000,'Each',35,''),('LITHIUM BATTERY CR2025','Elec',NULL,NULL,'',12.00,50.00,1.000,1.000,36,NULL,0,0,0,0,0,0,1.000,'Each',36,''),('ALKALINE BATTERY AG4','Elec',NULL,NULL,'',5.00,30.00,1.000,1.000,37,NULL,0,0,0,0,0,0,1.000,'Each',37,''),('ALKALINE BATTERY AG3','Elec',NULL,NULL,'',5.00,30.00,1.000,1.000,38,NULL,0,0,0,0,0,0,1.000,'Each',38,''),('ALKALINE BATTERY AG10','Elec',NULL,NULL,'',5.00,30.00,1.000,1.000,39,NULL,0,0,0,0,0,0,1.000,'Each',39,''),('ALKALINE BATTERY AG6','Elec',NULL,NULL,'',5.00,30.00,1.000,1.000,40,NULL,0,0,0,0,0,0,1.000,'Each',40,''),('CABLETIE 5*300mm WHITE','Elec',NULL,NULL,'',3.00,10.00,1.000,1.000,41,NULL,0,0,0,0,0,0,1.000,'Each',41,''),('CABLETIE 5*300mmBLACK','Elec',NULL,NULL,'',3.00,10.00,1.000,1.000,42,NULL,0,0,0,0,0,0,1.000,'Each',42,''),('CABLETIE 5*250mm WHITE','Elec',NULL,NULL,'',2.00,10.00,1.000,1.000,43,NULL,0,0,0,0,0,0,1.000,'Each',43,''),('CABLETIE 5*250mm BLACK','Elec',NULL,NULL,'',2.00,10.00,1.000,1.000,44,NULL,0,0,0,0,0,0,1.000,'Each',44,''),('CABLETIE 5*200mm WHITE','Elec',NULL,NULL,'',2.00,5.00,1.000,1.000,45,NULL,0,0,0,0,0,0,1.000,'Each',45,''),('RCA  3*3','Elec',NULL,NULL,'',30.00,50.00,1.000,1.000,46,NULL,0,0,0,0,0,0,1.000,'Each',46,''),('RCA 2*1','Elec',NULL,NULL,'',30.00,50.00,1.000,1.000,47,NULL,0,0,0,0,0,0,1.000,'Each',47,''),('COLOURED BLUE RCA 2*1','Elec',NULL,NULL,'',40.00,70.00,1.000,1.000,48,NULL,0,0,0,0,0,0,1.000,'Each',48,'');
/*!40000 ALTER TABLE `ospos_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_items_taxes`
--

DROP TABLE IF EXISTS `ospos_items_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_items_taxes` (
  `item_id` int(10) NOT NULL,
  `name` varchar(255) NOT NULL,
  `percent` decimal(15,3) NOT NULL,
  PRIMARY KEY (`item_id`,`name`,`percent`),
  CONSTRAINT `ospos_items_taxes_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_items_taxes`
--

LOCK TABLES `ospos_items_taxes` WRITE;
/*!40000 ALTER TABLE `ospos_items_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_items_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_migrations`
--

DROP TABLE IF EXISTS `ospos_migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_migrations`
--

LOCK TABLES `ospos_migrations` WRITE;
/*!40000 ALTER TABLE `ospos_migrations` DISABLE KEYS */;
INSERT INTO `ospos_migrations` VALUES (20200819000000);
/*!40000 ALTER TABLE `ospos_migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_modules`
--

DROP TABLE IF EXISTS `ospos_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_modules` (
  `name_lang_key` varchar(255) NOT NULL,
  `desc_lang_key` varchar(255) NOT NULL,
  `sort` int(10) NOT NULL,
  `module_id` varchar(255) NOT NULL,
  PRIMARY KEY (`module_id`),
  UNIQUE KEY `desc_lang_key` (`desc_lang_key`),
  UNIQUE KEY `name_lang_key` (`name_lang_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_modules`
--

LOCK TABLES `ospos_modules` WRITE;
/*!40000 ALTER TABLE `ospos_modules` DISABLE KEYS */;
INSERT INTO `ospos_modules` VALUES ('module_attributes','module_attributes_desc',107,'attributes'),('module_cashups','module_cashups_desc',110,'cashups'),('module_config','module_config_desc',900,'config'),('module_customers','module_customers_desc',10,'customers'),('module_employees','module_employees_desc',80,'employees'),('module_expenses','module_expenses_desc',108,'expenses'),('module_expenses_categories','module_expenses_categories_desc',109,'expenses_categories'),('module_giftcards','module_giftcards_desc',90,'giftcards'),('module_home','module_home_desc',1,'home'),('module_items','module_items_desc',20,'items'),('module_item_kits','module_item_kits_desc',30,'item_kits'),('module_messages','module_messages_desc',98,'messages'),('module_office','module_office_desc',999,'office'),('module_receivings','module_receivings_desc',60,'receivings'),('module_reports','module_reports_desc',50,'reports'),('module_sales','module_sales_desc',70,'sales'),('module_suppliers','module_suppliers_desc',40,'suppliers'),('module_taxes','module_taxes_desc',105,'taxes');
/*!40000 ALTER TABLE `ospos_modules` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_people`
--

DROP TABLE IF EXISTS `ospos_people`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_people` (
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `gender` int(1) DEFAULT NULL,
  `phone_number` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address_1` varchar(255) NOT NULL,
  `address_2` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `zip` varchar(255) NOT NULL,
  `country` varchar(255) NOT NULL,
  `comments` text NOT NULL,
  `person_id` int(10) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`person_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_people`
--

LOCK TABLES `ospos_people` WRITE;
/*!40000 ALTER TABLE `ospos_people` DISABLE KEYS */;
INSERT INTO `ospos_people` VALUES ('Betty','Jian',NULL,'0720282377','','Address 1','','','','','','',1),('Maggy','Mutindi',NULL,'','','','','','','','','',2);
/*!40000 ALTER TABLE `ospos_people` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_permissions`
--

DROP TABLE IF EXISTS `ospos_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_permissions` (
  `permission_id` varchar(255) NOT NULL,
  `module_id` varchar(255) NOT NULL,
  `location_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`permission_id`),
  KEY `module_id` (`module_id`),
  KEY `ospos_permissions_ibfk_2` (`location_id`),
  CONSTRAINT `ospos_permissions_ibfk_1` FOREIGN KEY (`module_id`) REFERENCES `ospos_modules` (`module_id`) ON DELETE CASCADE,
  CONSTRAINT `ospos_permissions_ibfk_2` FOREIGN KEY (`location_id`) REFERENCES `ospos_stock_locations` (`location_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_permissions`
--

LOCK TABLES `ospos_permissions` WRITE;
/*!40000 ALTER TABLE `ospos_permissions` DISABLE KEYS */;
INSERT INTO `ospos_permissions` VALUES ('attributes','attributes',NULL),('cashups','cashups',NULL),('config','config',NULL),('customers','customers',NULL),('employees','employees',NULL),('expenses','expenses',NULL),('expenses_categories','expenses_categories',NULL),('giftcards','giftcards',NULL),('home','home',NULL),('items','items',NULL),('items_Kathangaita','items',1),('item_kits','item_kits',NULL),('messages','messages',NULL),('office','office',NULL),('receivings','receivings',NULL),('receivings_Kathangaita','receivings',1),('reports','reports',NULL),('reports_categories','reports',NULL),('reports_customers','reports',NULL),('reports_discounts','reports',NULL),('reports_employees','reports',NULL),('reports_expenses_categories','reports',NULL),('reports_inventory','reports',NULL),('reports_items','reports',NULL),('reports_payments','reports',NULL),('reports_receivings','reports',NULL),('reports_sales','reports',NULL),('reports_sales_taxes','reports',NULL),('reports_suppliers','reports',NULL),('reports_taxes','reports',NULL),('sales','sales',NULL),('sales_change_price','sales',NULL),('sales_delete','sales',NULL),('sales_Kathangaita','sales',1),('suppliers','suppliers',NULL),('taxes','taxes',NULL);
/*!40000 ALTER TABLE `ospos_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_receivings`
--

DROP TABLE IF EXISTS `ospos_receivings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_receivings` (
  `receiving_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `supplier_id` int(10) DEFAULT NULL,
  `employee_id` int(10) NOT NULL DEFAULT '0',
  `comment` text,
  `receiving_id` int(10) NOT NULL AUTO_INCREMENT,
  `payment_type` varchar(20) DEFAULT NULL,
  `reference` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`receiving_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `employee_id` (`employee_id`),
  KEY `reference` (`reference`),
  KEY `receiving_time` (`receiving_time`),
  CONSTRAINT `ospos_receivings_ibfk_1` FOREIGN KEY (`employee_id`) REFERENCES `ospos_employees` (`person_id`),
  CONSTRAINT `ospos_receivings_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `ospos_suppliers` (`person_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_receivings`
--

LOCK TABLES `ospos_receivings` WRITE;
/*!40000 ALTER TABLE `ospos_receivings` DISABLE KEYS */;
INSERT INTO `ospos_receivings` VALUES ('2022-10-30 10:29:52',NULL,2,'',1,'Cash',NULL),('2022-10-30 10:35:38',NULL,2,'',2,'Cash',NULL),('2022-10-30 10:39:35',NULL,2,'',3,'Cash',NULL);
/*!40000 ALTER TABLE `ospos_receivings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_receivings_items`
--

DROP TABLE IF EXISTS `ospos_receivings_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_receivings_items` (
  `receiving_id` int(10) NOT NULL DEFAULT '0',
  `item_id` int(10) NOT NULL DEFAULT '0',
  `description` varchar(30) DEFAULT NULL,
  `serialnumber` varchar(30) DEFAULT NULL,
  `line` int(3) NOT NULL,
  `quantity_purchased` decimal(15,3) NOT NULL DEFAULT '0.000',
  `item_cost_price` decimal(15,2) NOT NULL,
  `item_unit_price` decimal(15,2) NOT NULL,
  `discount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_type` tinyint(2) NOT NULL DEFAULT '0',
  `item_location` int(11) NOT NULL,
  `receiving_quantity` decimal(15,3) NOT NULL DEFAULT '1.000',
  PRIMARY KEY (`receiving_id`,`item_id`,`line`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `ospos_receivings_items_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`),
  CONSTRAINT `ospos_receivings_items_ibfk_2` FOREIGN KEY (`receiving_id`) REFERENCES `ospos_receivings` (`receiving_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_receivings_items`
--

LOCK TABLES `ospos_receivings_items` WRITE;
/*!40000 ALTER TABLE `ospos_receivings_items` DISABLE KEYS */;
INSERT INTO `ospos_receivings_items` VALUES (1,2,'',NULL,1,1.000,60.00,65.00,0.00,0,1,1.000),(2,2,'',NULL,1,2.000,60.00,60.00,0.00,0,1,1.000),(3,2,'',NULL,1,10.000,60.00,60.00,0.00,0,1,1.000);
/*!40000 ALTER TABLE `ospos_receivings_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sales`
--

DROP TABLE IF EXISTS `ospos_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sales` (
  `sale_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `customer_id` int(10) DEFAULT NULL,
  `employee_id` int(10) NOT NULL DEFAULT '0',
  `comment` text,
  `invoice_number` varchar(32) DEFAULT NULL,
  `quote_number` varchar(32) DEFAULT NULL,
  `sale_id` int(10) NOT NULL AUTO_INCREMENT,
  `sale_status` tinyint(2) NOT NULL DEFAULT '0',
  `dinner_table_id` int(11) DEFAULT NULL,
  `work_order_number` varchar(32) DEFAULT NULL,
  `sale_type` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sale_id`),
  UNIQUE KEY `invoice_number` (`invoice_number`),
  KEY `customer_id` (`customer_id`),
  KEY `employee_id` (`employee_id`),
  KEY `sale_time` (`sale_time`),
  KEY `dinner_table_id` (`dinner_table_id`),
  CONSTRAINT `ospos_sales_ibfk_1` FOREIGN KEY (`employee_id`) REFERENCES `ospos_employees` (`person_id`),
  CONSTRAINT `ospos_sales_ibfk_2` FOREIGN KEY (`customer_id`) REFERENCES `ospos_customers` (`person_id`),
  CONSTRAINT `ospos_sales_ibfk_3` FOREIGN KEY (`dinner_table_id`) REFERENCES `ospos_dinner_tables` (`dinner_table_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sales`
--

LOCK TABLES `ospos_sales` WRITE;
/*!40000 ALTER TABLE `ospos_sales` DISABLE KEYS */;
INSERT INTO `ospos_sales` VALUES ('2022-10-30 03:21:16',NULL,2,'',NULL,NULL,1,2,NULL,NULL,0),('2022-10-30 10:30:49',NULL,2,'',NULL,NULL,2,2,NULL,NULL,0),('2022-10-30 10:45:59',NULL,2,'',NULL,NULL,3,2,NULL,NULL,0),('2022-10-30 19:45:22',NULL,1,'',NULL,NULL,4,0,NULL,NULL,0),('2022-10-30 19:48:22',NULL,1,'',NULL,NULL,5,0,NULL,NULL,0),('2022-10-30 19:57:51',NULL,1,'',NULL,NULL,6,0,NULL,NULL,0);
/*!40000 ALTER TABLE `ospos_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sales_items`
--

DROP TABLE IF EXISTS `ospos_sales_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sales_items` (
  `sale_id` int(10) NOT NULL DEFAULT '0',
  `item_id` int(10) NOT NULL DEFAULT '0',
  `description` varchar(255) DEFAULT NULL,
  `serialnumber` varchar(30) DEFAULT NULL,
  `line` int(3) NOT NULL DEFAULT '0',
  `quantity_purchased` decimal(15,3) NOT NULL DEFAULT '0.000',
  `item_cost_price` decimal(15,2) NOT NULL,
  `item_unit_price` decimal(15,2) NOT NULL,
  `discount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_type` tinyint(2) NOT NULL DEFAULT '0',
  `item_location` int(11) NOT NULL,
  `print_option` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sale_id`,`item_id`,`line`),
  KEY `sale_id` (`sale_id`),
  KEY `item_id` (`item_id`),
  KEY `item_location` (`item_location`),
  CONSTRAINT `ospos_sales_items_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`),
  CONSTRAINT `ospos_sales_items_ibfk_2` FOREIGN KEY (`sale_id`) REFERENCES `ospos_sales` (`sale_id`),
  CONSTRAINT `ospos_sales_items_ibfk_3` FOREIGN KEY (`item_location`) REFERENCES `ospos_stock_locations` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sales_items`
--

LOCK TABLES `ospos_sales_items` WRITE;
/*!40000 ALTER TABLE `ospos_sales_items` DISABLE KEYS */;
INSERT INTO `ospos_sales_items` VALUES (1,1,'','',1,1.000,60.00,100.00,0.00,0,1,0),(2,2,'','',1,1.000,60.00,100.00,0.00,0,1,0),(3,2,'','',1,1.000,60.00,100.00,0.00,0,1,0),(4,9,'','',1,1.000,850.00,1500.00,0.00,0,1,0),(5,7,'','',1,1.000,850.00,1500.00,0.00,0,1,0),(6,4,'','',1,1.000,25.00,40.00,0.00,0,1,0);
/*!40000 ALTER TABLE `ospos_sales_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sales_items_taxes`
--

DROP TABLE IF EXISTS `ospos_sales_items_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sales_items_taxes` (
  `sale_id` int(10) NOT NULL,
  `item_id` int(10) NOT NULL,
  `line` int(3) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `percent` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax_type` tinyint(2) NOT NULL DEFAULT '0',
  `rounding_code` tinyint(2) NOT NULL DEFAULT '0',
  `cascade_sequence` tinyint(2) NOT NULL DEFAULT '0',
  `item_tax_amount` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `sales_tax_code_id` int(11) DEFAULT NULL,
  `jurisdiction_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`sale_id`,`item_id`,`line`,`name`,`percent`),
  KEY `sale_id` (`sale_id`),
  KEY `item_id` (`item_id`),
  CONSTRAINT `ospos_sales_items_taxes_ibfk_1` FOREIGN KEY (`sale_id`) REFERENCES `ospos_sales_items` (`sale_id`),
  CONSTRAINT `ospos_sales_items_taxes_ibfk_2` FOREIGN KEY (`item_id`) REFERENCES `ospos_items` (`item_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sales_items_taxes`
--

LOCK TABLES `ospos_sales_items_taxes` WRITE;
/*!40000 ALTER TABLE `ospos_sales_items_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_sales_items_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sales_payments`
--

DROP TABLE IF EXISTS `ospos_sales_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sales_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(10) NOT NULL,
  `payment_type` varchar(40) NOT NULL,
  `payment_amount` decimal(15,2) NOT NULL,
  `cash_refund` decimal(15,2) NOT NULL DEFAULT '0.00',
  `employee_id` int(11) DEFAULT NULL,
  `payment_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reference_code` varchar(40) NOT NULL DEFAULT '',
  PRIMARY KEY (`payment_id`),
  KEY `payment_sale` (`sale_id`,`payment_type`),
  KEY `employee_id` (`employee_id`),
  KEY `payment_time` (`payment_time`),
  CONSTRAINT `ospos_sales_payments_ibfk_1` FOREIGN KEY (`sale_id`) REFERENCES `ospos_sales` (`sale_id`),
  CONSTRAINT `ospos_sales_payments_ibfk_2` FOREIGN KEY (`employee_id`) REFERENCES `ospos_employees` (`person_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sales_payments`
--

LOCK TABLES `ospos_sales_payments` WRITE;
/*!40000 ALTER TABLE `ospos_sales_payments` DISABLE KEYS */;
INSERT INTO `ospos_sales_payments` VALUES (1,1,'Cash',50.00,0.00,2,'2022-10-30 07:21:16',''),(2,1,'Mpesa Till',50.00,0.00,2,'2022-10-30 07:21:16',''),(3,2,'Cash',20.00,0.00,2,'2022-10-30 07:30:49',''),(4,2,'Mpesa Till',80.00,0.00,2,'2022-10-30 07:30:49',''),(5,3,'Cash',100.00,0.00,2,'2022-10-30 07:45:59',''),(6,4,'Cash',1500.00,0.00,1,'2022-10-30 16:45:22',''),(7,5,'Cash',1500.00,0.00,1,'2022-10-30 16:48:22',''),(8,6,'Cash',40.00,0.00,1,'2022-10-30 16:57:51','');
/*!40000 ALTER TABLE `ospos_sales_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sales_reward_points`
--

DROP TABLE IF EXISTS `ospos_sales_reward_points`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sales_reward_points` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) NOT NULL,
  `earned` float NOT NULL,
  `used` float NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sale_id` (`sale_id`),
  CONSTRAINT `ospos_sales_reward_points_ibfk_1` FOREIGN KEY (`sale_id`) REFERENCES `ospos_sales` (`sale_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sales_reward_points`
--

LOCK TABLES `ospos_sales_reward_points` WRITE;
/*!40000 ALTER TABLE `ospos_sales_reward_points` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_sales_reward_points` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sales_taxes`
--

DROP TABLE IF EXISTS `ospos_sales_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sales_taxes` (
  `sales_taxes_id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(10) NOT NULL,
  `jurisdiction_id` int(11) DEFAULT NULL,
  `tax_category_id` int(11) DEFAULT NULL,
  `tax_type` smallint(2) NOT NULL,
  `tax_group` varchar(32) NOT NULL,
  `sale_tax_basis` decimal(15,4) NOT NULL,
  `sale_tax_amount` decimal(15,4) NOT NULL,
  `print_sequence` tinyint(2) NOT NULL DEFAULT '0',
  `name` varchar(255) NOT NULL,
  `tax_rate` decimal(15,4) NOT NULL,
  `sales_tax_code_id` int(11) DEFAULT NULL,
  `rounding_code` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sales_taxes_id`),
  KEY `print_sequence` (`sale_id`,`print_sequence`,`tax_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sales_taxes`
--

LOCK TABLES `ospos_sales_taxes` WRITE;
/*!40000 ALTER TABLE `ospos_sales_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_sales_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_sessions`
--

DROP TABLE IF EXISTS `ospos_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT '0',
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_sessions`
--

LOCK TABLES `ospos_sessions` WRITE;
/*!40000 ALTER TABLE `ospos_sessions` DISABLE KEYS */;
INSERT INTO `ospos_sessions` VALUES ('5gqkcea1j6epgdt1d6436a1a9po1lk78','196.216.95.102',1667113885,_binary '__ci_last_regenerate|i:1667113460;'),('5gqkcea1j6epgdt1d6436a1a9po1lk78','196.216.95.67',1667114118,_binary '__ci_last_regenerate|i:1667113474;person_id|s:1:\"1\";menu_group|s:4:\"home\";'),('5gqkcea1j6epgdt1d6436a1a9po1lk78','196.216.95.59',1667113745,_binary '__ci_last_regenerate|i:1667113520;person_id|s:1:\"1\";menu_group|s:6:\"office\";sale_id|i:-1;'),('5gqkcea1j6epgdt1d6436a1a9po1lk78','196.216.95.96',1667114118,_binary '__ci_last_regenerate|i:1667113534;person_id|s:1:\"1\";menu_group|s:6:\"office\";'),('5gqkcea1j6epgdt1d6436a1a9po1lk78','102.216.84.102',1667113932,_binary '__ci_last_regenerate|i:1667113696;person_id|s:1:\"1\";menu_group|s:6:\"office\";'),('6ap69sjv13vhtfh5j0el71sptj4uje04','196.216.95.102',1667113885,_binary '__ci_last_regenerate|i:1667113883;'),('53gsmkj6176v6bdvpioq28nv5oh79gcs','196.216.95.96',1667114248,_binary '__ci_last_regenerate|i:1667114122;'),('53gsmkj6176v6bdvpioq28nv5oh79gcs','196.216.95.59',1667114140,_binary '__ci_last_regenerate|i:1667114140;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('53gsmkj6176v6bdvpioq28nv5oh79gcs','102.216.84.102',1667114414,_binary '__ci_last_regenerate|i:1667114152;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;item_location|s:1:\"1\";sale_id|i:-1;sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"1\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:25:\"4 G Power  Travel Charger\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:5:\"9.000\";s:5:\"price\";s:6:\"100.00\";s:10:\"cost_price\";s:5:\"60.00\";s:5:\"total\";s:6:\"100.00\";s:16:\"discounted_total\";s:8:\"100.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('53gsmkj6176v6bdvpioq28nv5oh79gcs','196.216.95.67',1667114346,''),('53gsmkj6176v6bdvpioq28nv5oh79gcs','196.216.95.102',1667114432,_binary '__ci_last_regenerate|i:1667114432;'),('j0prbr7ep8sgqg1958oe5g0u8bdnjmb6','102.216.84.102',1667114595,_binary '__ci_last_regenerate|i:1667114503;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('j0prbr7ep8sgqg1958oe5g0u8bdnjmb6','196.216.95.102',1667114539,_binary '__ci_last_regenerate|i:1667114533;person_id|s:1:\"1\";menu_group|s:6:\"office\";'),('j0prbr7ep8sgqg1958oe5g0u8bdnjmb6','196.216.95.67',1667114568,_binary '__ci_last_regenerate|i:1667114568;'),('0d89d1h3gdtedo6sq15pd5l4rfjttv1c','196.216.95.96',1667114629,_binary '__ci_last_regenerate|i:1667114629;'),('01gv6g3foepsl98fm74qeuh5cl2dffhj','102.216.84.102',1667115049,_binary '__ci_last_regenerate|i:1667114749;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";recv_stock_source|s:1:\"1\";sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";'),('01gv6g3foepsl98fm74qeuh5cl2dffhj','196.216.95.67',1667114784,_binary '__ci_last_regenerate|i:1667114780;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('01gv6g3foepsl98fm74qeuh5cl2dffhj','196.216.95.102',1667115012,_binary '__ci_last_regenerate|i:1667114889;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;item_location|s:1:\"1\";sale_id|i:-1;sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"2\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:18:\"3 G Travel Charger\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:5:\"2.000\";s:5:\"price\";s:6:\"100.00\";s:10:\"cost_price\";s:5:\"60.00\";s:5:\"total\";s:6:\"100.00\";s:16:\"discounted_total\";s:8:\"100.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('01gv6g3foepsl98fm74qeuh5cl2dffhj','196.216.95.96',1667114865,''),('kp7d0klqnpnk4n2n7m23t11e4oi0gpbv','102.216.84.102',1667115363,_binary '__ci_last_regenerate|i:1667115071;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";recv_stock_source|s:1:\"1\";sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"2\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:18:\"3 G Travel Charger\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:5:\"1.000\";s:5:\"price\";s:6:\"100.00\";s:10:\"cost_price\";s:5:\"60.00\";s:5:\"total\";s:6:\"100.00\";s:16:\"discounted_total\";s:8:\"100.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('kp7d0klqnpnk4n2n7m23t11e4oi0gpbv','196.216.95.59',1667115457,_binary '__ci_last_regenerate|i:1667115091;person_id|s:1:\"2\";menu_group|s:4:\"home\";recv_cart|a:0:{}recv_mode|s:7:\"receive\";recv_supplier|i:-1;'),('kp7d0klqnpnk4n2n7m23t11e4oi0gpbv','196.216.95.67',1667115124,_binary '__ci_last_regenerate|i:1667115124;'),('kp7d0klqnpnk4n2n7m23t11e4oi0gpbv','196.216.95.96',1667115187,_binary '__ci_last_regenerate|i:1667115173;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";recv_cart|a:0:{}recv_mode|s:7:\"receive\";recv_supplier|i:-1;'),('70ehinhee9fj2sp2kdh34fuoa239alrt','102.216.84.102',1667115720,_binary '__ci_last_regenerate|i:1667115535;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";recv_stock_source|s:1:\"1\";sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"2\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:18:\"3 G Travel Charger\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:5:\"1.000\";s:5:\"price\";s:6:\"100.00\";s:10:\"cost_price\";s:5:\"60.00\";s:5:\"total\";s:6:\"100.00\";s:16:\"discounted_total\";s:8:\"100.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('70ehinhee9fj2sp2kdh34fuoa239alrt','196.216.95.96',1667115660,_binary '__ci_last_regenerate|i:1667115641;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('70ehinhee9fj2sp2kdh34fuoa239alrt','196.216.95.102',1667115934,_binary '__ci_last_regenerate|i:1667115913;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"2\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:18:\"3 G Travel Charger\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:6:\"11.000\";s:5:\"price\";s:6:\"100.00\";s:10:\"cost_price\";s:5:\"60.00\";s:5:\"total\";s:6:\"100.00\";s:16:\"discounted_total\";s:8:\"100.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('2a663e5pp1vg8v9rrp4ga2gu3c49voj4','196.216.95.96',1667116007,_binary '__ci_last_regenerate|i:1667115947;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;item_location|s:1:\"1\";sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_cart|a:0:{}sales_customer|i:-1;sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('5rca6ap2k0lvfn8ivndfjf5210qeh2ea','102.216.84.102',1667116218,_binary '__ci_last_regenerate|i:1667116218;'),('5rca6ap2k0lvfn8ivndfjf5210qeh2ea','196.216.95.67',1667116324,_binary '__ci_last_regenerate|i:1667116251;'),('5rca6ap2k0lvfn8ivndfjf5210qeh2ea','196.216.95.59',1667116303,_binary '__ci_last_regenerate|i:1667116293;person_id|s:1:\"1\";menu_group|s:6:\"office\";'),('b2d92jukl996bqh0tmn4miv05nnm75g2','196.216.95.102',1667116340,_binary '__ci_last_regenerate|i:1667116340;'),('b2d92jukl996bqh0tmn4miv05nnm75g2','196.216.95.59',1667116493,_binary '__ci_last_regenerate|i:1667116391;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('b2d92jukl996bqh0tmn4miv05nnm75g2','196.216.95.67',1667116481,_binary '__ci_last_regenerate|i:1667116445;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('7t190358rft1kt4d2ldq037qbv9gd3c1','102.216.84.102',1667118990,_binary '__ci_last_regenerate|i:1667116518;person_id|s:1:\"2\";menu_group|s:4:\"home\";item_location|s:1:\"1\";'),('7t190358rft1kt4d2ldq037qbv9gd3c1','196.216.95.67',1667119005,_binary '__ci_last_regenerate|i:1667116541;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('7t190358rft1kt4d2ldq037qbv9gd3c1','196.216.95.96',1667118989,_binary '__ci_last_regenerate|i:1667116699;person_id|s:1:\"2\";menu_group|s:4:\"home\";recv_cart|a:0:{}recv_mode|s:7:\"receive\";recv_supplier|i:-1;allow_temp_items|i:0;item_location|s:1:\"1\";'),('7t190358rft1kt4d2ldq037qbv9gd3c1','196.216.95.102',1667118972,_binary '__ci_last_regenerate|i:1667117919;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('7t190358rft1kt4d2ldq037qbv9gd3c1','196.216.95.59',1667118723,''),('9ll7p770cmfpt180kkh9c0ogsnpqbavh','102.216.84.102',1667119897,_binary '__ci_last_regenerate|i:1667119021;person_id|s:1:\"2\";menu_group|s:4:\"home\";item_location|s:1:\"1\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;recv_cart|a:0:{}recv_mode|s:7:\"receive\";recv_supplier|i:-1;'),('9ll7p770cmfpt180kkh9c0ogsnpqbavh','196.216.95.102',1667119870,''),('9ll7p770cmfpt180kkh9c0ogsnpqbavh','196.216.95.96',1667119936,_binary '__ci_last_regenerate|i:1667119161;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('38len7ghiojv9m52jm15272d9ipp85mq','95.164.153.160',1667119109,_binary '__ci_last_regenerate|i:1667119109;'),('9ll7p770cmfpt180kkh9c0ogsnpqbavh','196.216.95.67',1667119875,_binary '__ci_last_regenerate|i:1667119115;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('rsaakgpm1t56i703d905s98f1b723taa','3.93.149.237',1667119288,_binary '__ci_last_regenerate|i:1667119288;'),('9ll7p770cmfpt180kkh9c0ogsnpqbavh','196.216.95.59',1667120080,''),('2milrfevphsf0in1446bish4jqm9qo9b','196.216.95.67',1667120382,_binary '__ci_last_regenerate|i:1667120094;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('2milrfevphsf0in1446bish4jqm9qo9b','102.216.84.102',1667120376,_binary '__ci_last_regenerate|i:1667120099;person_id|s:1:\"2\";item_location|s:1:\"1\";'),('2milrfevphsf0in1446bish4jqm9qo9b','196.216.95.96',1667120382,_binary '__ci_last_regenerate|i:1667120115;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('2milrfevphsf0in1446bish4jqm9qo9b','196.216.95.59',1667120420,''),('sip6pl12vsor9qcj10634q0837diodq5','196.216.95.96',1667129414,_binary '__ci_last_regenerate|i:1667120432;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('sip6pl12vsor9qcj10634q0837diodq5','196.216.95.67',1667128937,_binary '__ci_last_regenerate|i:1667120454;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('sip6pl12vsor9qcj10634q0837diodq5','102.216.84.102',1667129311,_binary '__ci_last_regenerate|i:1667121880;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('sip6pl12vsor9qcj10634q0837diodq5','196.216.95.59',1667129382,_binary '__ci_last_regenerate|i:1667120899;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('sip6pl12vsor9qcj10634q0837diodq5','196.216.95.102',1667128997,_binary '__ci_last_regenerate|i:1667121013;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('0dalqe8ta03mvdp5q5144pe8aq60pdki','87.115.231.209',1667129389,_binary '__ci_last_regenerate|i:1667129389;'),('3n5uf13243jt48hdglg3jc4t8dpa6gkq','31.6.10.81',1667129389,_binary '__ci_last_regenerate|i:1667129389;'),('lol8rvqfe778m1rh9dvceuva54v38hfc','31.6.10.81',1667129389,_binary '__ci_last_regenerate|i:1667129389;'),('92f77cl7jtv3k529n45hmsuvjmtkt1h0','87.115.231.209',1667129389,_binary '__ci_last_regenerate|i:1667129389;'),('k52tmae8d487nv1obmoclhcdfcdo4ha9','161.35.246.138',1667129389,_binary '__ci_last_regenerate|i:1667129389;'),('m55ifnour0tf3i1oeo7qgk285ihqttrv','107.181.189.145',1667129389,_binary '__ci_last_regenerate|i:1667129389;'),('odaimme06d5i1qdc3gqc1ep6luk07vop','161.35.246.138',1667129390,_binary '__ci_last_regenerate|i:1667129390;'),('5g14lsjtkn1lqtb6mcuil7p3ninch60n','138.199.18.144',1667129390,_binary '__ci_last_regenerate|i:1667129390;'),('o285a5k3k38jqclrvlekdqu9qdqcebms','107.181.189.145',1667129390,_binary '__ci_last_regenerate|i:1667129390;'),('lhleorgdk362an5dn55alvca2pukggv6','138.199.18.144',1667129390,_binary '__ci_last_regenerate|i:1667129390;'),('60blv52gl253u2rtn5ki7t37d6m0vbd4','196.216.95.96',1667131160,_binary '__ci_last_regenerate|i:1667129923;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;item_location|s:1:\"1\";sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('60blv52gl253u2rtn5ki7t37d6m0vbd4','102.216.84.102',1667131239,_binary '__ci_last_regenerate|i:1667129977;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";sales_mode|s:4:\"sale\";'),('60blv52gl253u2rtn5ki7t37d6m0vbd4','196.216.95.59',1667130021,''),('60blv52gl253u2rtn5ki7t37d6m0vbd4','196.216.95.102',1667131185,_binary '__ci_last_regenerate|i:1667130859;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('60blv52gl253u2rtn5ki7t37d6m0vbd4','196.216.95.67',1667131202,''),('rbo6cmgrsn0l2tuj3v01pllohdkceehe','102.216.84.102',1667131415,_binary '__ci_last_regenerate|i:1667131415;'),('jqpfgld2coiq90h4o8mqv690h8mdgjvr','102.216.84.102',1667136499,_binary '__ci_last_regenerate|i:1667133039;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('kk67en23r4ldfhbqvl617vlqnilklrku','102.216.84.102',1667142978,_binary '__ci_last_regenerate|i:1667142824;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('i7d6m45dmg05d6lv32p8375k5ktslnu7','102.216.84.102',1667148160,_binary '__ci_last_regenerate|i:1667147986;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"9\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:14:\"Horizon shower\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:5:\"1.000\";s:5:\"price\";s:7:\"1500.00\";s:10:\"cost_price\";s:6:\"850.00\";s:5:\"total\";s:7:\"1500.00\";s:16:\"discounted_total\";s:9:\"1500.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('0vq064eh6ihjodhfbeuhhq9jarhphh9k','102.216.84.102',1667148684,_binary '__ci_last_regenerate|i:1667148300;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";item_location|s:1:\"1\";'),('6i3rgsbmv37qpnouc423auoh49vpplvp','102.216.84.102',1667149049,_binary '__ci_last_regenerate|i:1667148750;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";item_location|s:1:\"1\";sales_cart|a:1:{i:1;a:25:{s:7:\"item_id\";s:1:\"4\";s:13:\"item_location\";s:1:\"1\";s:10:\"stock_name\";s:11:\"Kathangaita\";s:4:\"line\";i:1;s:4:\"name\";s:16:\"Alteco superglue\";s:11:\"item_number\";N;s:16:\"attribute_values\";N;s:18:\"attribute_dtvalues\";N;s:11:\"description\";s:0:\"\";s:12:\"serialnumber\";s:0:\"\";s:21:\"allow_alt_description\";s:1:\"0\";s:13:\"is_serialized\";s:1:\"0\";s:8:\"quantity\";i:1;s:8:\"discount\";s:1:\"0\";s:13:\"discount_type\";s:1:\"0\";s:8:\"in_stock\";s:6:\"14.000\";s:5:\"price\";s:5:\"40.00\";s:10:\"cost_price\";s:5:\"25.00\";s:5:\"total\";s:5:\"40.00\";s:16:\"discounted_total\";s:7:\"40.0000\";s:12:\"print_option\";i:0;s:10:\"stock_type\";s:1:\"0\";s:9:\"item_type\";s:1:\"0\";s:8:\"hsn_code\";s:0:\"\";s:15:\"tax_category_id\";s:1:\"0\";}}sales_customer|i:-1;sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('a2tbfiksp80hfjqfu27smcrli731fv4j','102.216.84.102',1667149086,_binary '__ci_last_regenerate|i:1667149058;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";item_location|s:1:\"1\";'),('gs904p5j1vta02udo55ofieq1hu0c8an','102.216.84.102',1667150550,_binary '__ci_last_regenerate|i:1667149603;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";item_location|s:1:\"1\";sales_cart|a:0:{}sales_customer|i:-1;sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('ob6upicevceg9duecpc31sprhq9cvech','82.193.104.168',1667152540,_binary '__ci_last_regenerate|i:1667152540;'),('npum4drrfoasdl9ifbf1ohdggrbk7v6p','104.238.153.175',1667163608,_binary '__ci_last_regenerate|i:1667163608;'),('35k4e3h7d89ua5mt76mpuq4u23n4c0t9','104.168.90.39',1667163608,_binary '__ci_last_regenerate|i:1667163608;'),('dm1db64nk2uof90n4ofkjoq7df0vjbrg','51.89.228.207',1667172752,_binary '__ci_last_regenerate|i:1667172752;'),('ptlptkn9t6uqeje9og3qpnuh9tr3lba8','51.89.228.207',1667172752,_binary '__ci_last_regenerate|i:1667172752;'),('6u7i2tqgrbrgvj61rkr81es5mkor9p18','196.96.50.150',1667191714,_binary '__ci_last_regenerate|i:1667191714;'),('lvs34tt8geap8m511q2antmlon51be1b','197.155.95.5',1667191718,_binary '__ci_last_regenerate|i:1667191718;'),('a03cojt0t54mtmqf5skvlvt031jqqccr','196.96.50.150',1667191747,_binary '__ci_last_regenerate|i:1667191747;person_id|s:1:\"1\";'),('dh27ubqf8v7rhojnr1ejcmmsktkr5ost','196.96.50.150',1667191748,_binary '__ci_last_regenerate|i:1667191748;'),('59voat6fvovr0jurp9nfhmhmqi1sje3f','196.96.50.150',1667191748,_binary '__ci_last_regenerate|i:1667191748;'),('oei8f1n1clc370esb0vstmuqfdn00ddo','197.136.0.5',1667191751,_binary '__ci_last_regenerate|i:1667191751;'),('ro9mjqmq45ggsjttt9abg12dr8931t9v','196.96.50.150',1667191771,_binary '__ci_last_regenerate|i:1667191771;person_id|s:1:\"1\";'),('8k8jmvnefhhp24gk2o0k3fphngo6c31e','196.96.50.150',1667191772,_binary '__ci_last_regenerate|i:1667191772;'),('u95p7lmh0kaa115rmhd5kllbovgtr3nf','196.96.50.150',1667191772,_binary '__ci_last_regenerate|i:1667191772;'),('shmm5gaoonjpbnhhvk14f6a10a42q2d6','196.96.50.150',1667191794,_binary '__ci_last_regenerate|i:1667191794;'),('vp9m19n7g44r5eiq6074rpb786b1bb8q','196.96.50.150',1667191825,_binary '__ci_last_regenerate|i:1667191825;person_id|s:1:\"1\";'),('90e2t73s9oisl5a63jkidhjoopu35jeu','196.96.50.150',1667191825,_binary '__ci_last_regenerate|i:1667191825;'),('phtn0mdjphl30hi7kcvaa6gglisi4bvf','196.96.50.150',1667191825,_binary '__ci_last_regenerate|i:1667191825;'),('icrvpeg29vrsto85b2lgl6fh5jmc1187','196.96.50.150',1667191845,_binary '__ci_last_regenerate|i:1667191845;'),('ji6abi8h9rag8ic4i7g5uus22hhuvjcl','196.96.50.150',1667191894,_binary '__ci_last_regenerate|i:1667191894;person_id|s:1:\"1\";'),('9fvtl2cb662cpcc4jcu93ke5cdihd21d','196.96.50.150',1667191894,_binary '__ci_last_regenerate|i:1667191894;'),('8e835vpr5kae00pkdkl7k2f1rrtq0ij0','196.96.50.150',1667191895,_binary '__ci_last_regenerate|i:1667191895;'),('9jllfhub4u9k9m6inkti3ih8jmkb4jmm','196.96.50.150',1667191918,_binary '__ci_last_regenerate|i:1667191917;'),('u6maq941b01jgu5ddde1f3m04u112eok','196.96.50.150',1667192014,_binary '__ci_last_regenerate|i:1667192013;person_id|s:1:\"1\";'),('gufu4gfd8v6h35siffvl923cs3scqjqo','196.96.50.150',1667192014,_binary '__ci_last_regenerate|i:1667192014;'),('5492bf03h569ihsgv5fte9lgcm11bdf2','196.96.50.150',1667192014,_binary '__ci_last_regenerate|i:1667192014;'),('a2pudf77irmqui3u8m2d964e9fccei1b','196.96.50.150',1667192028,_binary '__ci_last_regenerate|i:1667192028;'),('tbc17f9243bjrtu0lfo4gd63tuf2k8t3','196.96.50.150',1667192032,_binary '__ci_last_regenerate|i:1667192032;'),('92ouog49at0ut10qc0fap8754krlr8bp','196.96.50.150',1667192040,_binary '__ci_last_regenerate|i:1667192040;'),('9tiur9kmg7lrrq88ha6v5fbutfuddq1t','196.96.50.150',1667192066,_binary '__ci_last_regenerate|i:1667192066;person_id|s:1:\"1\";'),('tb2a0g3u5amtjfrm6jik7v0fq3gvko8l','196.96.50.150',1667192067,_binary '__ci_last_regenerate|i:1667192067;'),('m6lf12q59v4b1d1bokeadrfajlv0rpfk','196.96.50.150',1667192067,_binary '__ci_last_regenerate|i:1667192067;'),('445kepe0uptbamcrnnqnueo6un0qhamq','102.217.7.34',1667192445,_binary '__ci_last_regenerate|i:1667192205;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('4va4epidjvf8evgp81shju8nrscul1hn','197.155.95.5',1667192210,_binary '__ci_last_regenerate|i:1667192210;'),('3952k6eaq549aufo0ojdt04vvc0b15t1','196.96.50.150',1667192573,_binary '__ci_last_regenerate|i:1667192573;'),('6ci20blobgofqfbjjn4n24a4llr8jf43','196.96.50.150',1667192577,_binary '__ci_last_regenerate|i:1667192577;'),('fipak541vqu681ik9uel3g4tm744vacv','196.96.50.150',1667192600,_binary '__ci_last_regenerate|i:1667192599;'),('f3prqkf21fursicuh0idmd738vsuqird','196.96.50.150',1667192628,_binary '__ci_last_regenerate|i:1667192628;person_id|s:1:\"1\";'),('fqfnajko02f229o9eh7l1brddkc4e6qt','196.96.50.150',1667192628,_binary '__ci_last_regenerate|i:1667192628;'),('7u3u6v1dapqoahggia4tlbd03i1jo5g3','196.96.50.150',1667192629,_binary '__ci_last_regenerate|i:1667192629;'),('snhvqfmjq9h1e0vcetla5920klrig79o','196.96.50.150',1667193023,_binary '__ci_last_regenerate|i:1667193023;'),('bbb0bhhrdtd8tfkl0pn9tn506ej0vchp','196.96.50.150',1667193039,_binary '__ci_last_regenerate|i:1667193039;person_id|s:1:\"1\";'),('fl2tlddbqg9jbduhv5djth3slt4le6mv','196.96.50.150',1667193039,_binary '__ci_last_regenerate|i:1667193039;'),('np9lcnesnd681v2kp5krf82bj8e7eh31','196.96.50.150',1667193039,_binary '__ci_last_regenerate|i:1667193039;'),('eu26dq81pd95out830die0263mj0mj2f','196.96.50.150',1667193073,_binary '__ci_last_regenerate|i:1667193073;person_id|s:1:\"1\";'),('ur3200v6goh2ueuluqffp7jnc7069s58','196.96.50.150',1667193073,_binary '__ci_last_regenerate|i:1667193073;'),('4i29un36udh1v0qcpfbc4mntgf4vlgcv','196.96.50.150',1667193074,_binary '__ci_last_regenerate|i:1667193074;'),('833tr49ufqh5uli28qvcpd20qc4461el','196.96.50.150',1667193078,_binary '__ci_last_regenerate|i:1667193078;'),('j6781s6bbpumosjml6098sl8o2ftbc0p','196.96.50.150',1667193097,_binary '__ci_last_regenerate|i:1667193097;person_id|s:1:\"1\";'),('02e53accciq94nfco6qv42vg16dn9c4a','196.96.50.150',1667193098,_binary '__ci_last_regenerate|i:1667193098;'),('57efhrqclgh22f2skt7cv86e9osegp98','196.96.50.150',1667193098,_binary '__ci_last_regenerate|i:1667193098;'),('8gssrthpmph58rqb5gc2ebled0vr5ntq','196.96.50.150',1667193471,_binary '__ci_last_regenerate|i:1667193471;'),('6sh485u7be8gemde7bpb6sm3gaqnv1a3','196.96.50.150',1667193480,_binary '__ci_last_regenerate|i:1667193480;'),('pg9t33k9ul2be4evncg9rj31imlhs41t','196.96.50.150',1667193485,_binary '__ci_last_regenerate|i:1667193485;'),('133kotkhrpttukabn5l7k3qb365smc3p','196.96.50.150',1667193498,_binary '__ci_last_regenerate|i:1667193498;person_id|s:1:\"1\";'),('233qv73u0jg9c8gk8o2eahs4ajmfnn1h','196.96.50.150',1667193498,_binary '__ci_last_regenerate|i:1667193498;'),('ogqdqeruj56r535auq82ikrf8aj1gcm8','196.96.50.150',1667193499,_binary '__ci_last_regenerate|i:1667193499;'),('d5ri6tear30kj3bcrn37h26cu7vud16p','196.96.50.150',1667193504,_binary '__ci_last_regenerate|i:1667193504;'),('ocni4jqf94iq60563h7pkje57ais9e0b','196.96.50.150',1667193514,_binary '__ci_last_regenerate|i:1667193514;'),('5mv5h1b5apmhqojs8ujbiq0v3fi6gkmf','196.96.50.150',1667193517,_binary '__ci_last_regenerate|i:1667193517;'),('78hpg8fvlgm7anepf9v05e7m4q9ktm9l','196.96.50.150',1667193519,_binary '__ci_last_regenerate|i:1667193519;'),('f3fmng9f1q5ru3oma25phunm67p8rjdh','196.96.50.150',1667193596,_binary '__ci_last_regenerate|i:1667193596;'),('luivkpf8pndk1c6moejt5rn80iekkim9','196.96.50.150',1667193606,_binary '__ci_last_regenerate|i:1667193606;'),('f7gefuurls6i490t2li80a15v973dd5v','196.96.50.150',1667193608,_binary '__ci_last_regenerate|i:1667193608;'),('adanpofdatsl0qacde3hnc9d4m71jvhf','196.96.50.150',1667193977,_binary '__ci_last_regenerate|i:1667193977;'),('anr6qvou527mlpscjd4h8b06q8ikmeqg','102.217.7.34',1667193996,_binary '__ci_last_regenerate|i:1667193996;'),('i9a54420s36j0ec1kglu640mouf24nun','102.217.7.34',1667194001,_binary '__ci_last_regenerate|i:1667193996;person_id|s:1:\"1\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('e37r1eoalivkq75l8hb6961skg48b92r','102.217.7.34',1667194020,_binary '__ci_last_regenerate|i:1667194020;person_id|s:1:\"1\";'),('ilnrk20tgm11e7pc3di5b7i6t41t15cd','102.217.7.34',1667194020,_binary '__ci_last_regenerate|i:1667194020;'),('5iuf9gqbok8lbhv7th789h9dl2jp9nrv','102.217.7.34',1667194021,_binary '__ci_last_regenerate|i:1667194021;'),('q6pg4afj63i28mnd8p5gmod1q43jjdhd','102.217.7.34',1667194044,_binary '__ci_last_regenerate|i:1667194044;person_id|s:1:\"1\";'),('osb7anolvnpgl102bsu1aivhfe6uh8jb','102.217.7.34',1667194044,_binary '__ci_last_regenerate|i:1667194044;'),('et3021uppf6hlmf8fqor5ca9pv7gupdv','102.217.7.34',1667194044,_binary '__ci_last_regenerate|i:1667194044;'),('d9ktb28lpeemfbovt4cthq78lqp5g26l','102.216.84.102',1667194065,_binary '__ci_last_regenerate|i:1667194057;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('ramnht6tev2m669co1pcsegnvqk8gilb','102.217.7.34',1667194060,_binary '__ci_last_regenerate|i:1667194060;person_id|s:1:\"1\";'),('9ddq4k47alpfg719kiro8i74kpak4h8t','102.217.7.34',1667194061,_binary '__ci_last_regenerate|i:1667194061;'),('2da151bl7afjf55flg4f7pc7866jaupi','102.217.7.34',1667194061,_binary '__ci_last_regenerate|i:1667194061;'),('d0rqbakjjvkvjs179ilqscu457d8d8gi','102.217.7.34',1667194066,_binary '__ci_last_regenerate|i:1667194066;'),('d9ktb28lpeemfbovt4cthq78lqp5g26l','196.216.95.96',1667194098,_binary '__ci_last_regenerate|i:1667194085;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('4rd125ocmf1a36v7b8p7lhmeoijdsc4c','102.217.7.34',1667194086,_binary '__ci_last_regenerate|i:1667194086;'),('2vsru60gsr9e3hfpubs076irdp88d8ol','196.96.50.150',1667194089,_binary '__ci_last_regenerate|i:1667194089;'),('2nvd42hf9casm0k4i1cqubgm9jcuf667','102.217.7.34',1667194105,_binary '__ci_last_regenerate|i:1667194105;person_id|s:1:\"1\";'),('515blva46obh96j8dcnsil9egqs826lp','102.217.7.34',1667194105,_binary '__ci_last_regenerate|i:1667194105;'),('7o34ueb23jtmvocag6pb6fqqg27783pq','102.217.7.34',1667194105,_binary '__ci_last_regenerate|i:1667194105;'),('6fi5us8j3i6qk7moi2hvd9p0g1lvaimd','196.96.50.150',1667194108,_binary '__ci_last_regenerate|i:1667194108;person_id|s:1:\"1\";'),('03p0dri9kih9onc8m8slriih01j0qkv7','196.96.50.150',1667194108,_binary '__ci_last_regenerate|i:1667194108;'),('e8ebgfir4t89e9jignr6mbkalolcchb7','196.96.50.150',1667194109,_binary '__ci_last_regenerate|i:1667194109;'),('pbu4t9jm2vb272o62ev2ldjdu6sidfpc','196.96.50.150',1667194116,_binary '__ci_last_regenerate|i:1667194116;'),('geh5fvushp2dqp09fltna7n2uv091qki','102.217.7.34',1667194126,_binary '__ci_last_regenerate|i:1667194126;'),('9m2gghekquvda7gjnncguf9gaoup6dm6','196.96.50.150',1667194144,_binary '__ci_last_regenerate|i:1667194144;'),('e5bdnt6en22dp05q3hle7f2mkfamd267','102.217.7.34',1667194145,_binary '__ci_last_regenerate|i:1667194145;'),('4a79v8n8scbpcc4h8qjsq60losf2bg6d','196.96.50.150',1667194368,_binary '__ci_last_regenerate|i:1667194368;'),('8sn47nhituapucpd0ncv8j0a5b945dco','196.96.50.150',1667194510,_binary '__ci_last_regenerate|i:1667194510;'),('tkru8aj3thg6ki44lr4johp7kbs93h9k','196.96.50.150',1667194666,_binary '__ci_last_regenerate|i:1667194666;person_id|s:1:\"1\";'),('orjpedebhad125rubsmj8h5a61c3o6e6','196.96.50.150',1667194666,_binary '__ci_last_regenerate|i:1667194666;'),('k5ur4d3i6andl0cam4vdg1kispfsi5qg','196.96.50.150',1667194667,_binary '__ci_last_regenerate|i:1667194667;'),('6aup7ol6mf03klhq4vvbfvpnt0q3pmhp','196.96.50.150',1667194927,_binary '__ci_last_regenerate|i:1667194927;'),('hrj93u53bl9q0ksu2kjordfbokqd45pa','196.96.50.150',1667194930,_binary '__ci_last_regenerate|i:1667194930;'),('irqnjhv051u21ck8fcpqj58ghnppo7m5','196.96.50.150',1667194955,_binary '__ci_last_regenerate|i:1667194955;'),('hrcnn3prmu33npkr6q5n3lkdajcit63e','196.96.50.150',1667194974,_binary '__ci_last_regenerate|i:1667194974;person_id|s:1:\"1\";'),('trr52555lblhh35r67gffdadp4nkm3lc','196.96.50.150',1667194974,_binary '__ci_last_regenerate|i:1667194974;'),('i492loagfoiera1tjgl79mlk529plnuh','196.96.50.150',1667194975,_binary '__ci_last_regenerate|i:1667194975;'),('v629028ka43e1mqmp4hbr76v59gh13mh','196.96.50.150',1667195016,_binary '__ci_last_regenerate|i:1667195016;'),('b2evr3a9ano975kgfm1tsrjpj0avi5f5','196.96.50.150',1667195021,_binary '__ci_last_regenerate|i:1667195021;'),('73e4u2edsfkbjkire561p9pqk7g8ijej','196.96.50.150',1667195024,_binary '__ci_last_regenerate|i:1667195024;'),('h4momm5frpvib78k16q0tf2s0ammnd6u','196.96.50.150',1667195049,_binary '__ci_last_regenerate|i:1667195049;'),('lvtshaoma35sl21k783l6k20c29j4t13','196.96.50.150',1667195482,_binary '__ci_last_regenerate|i:1667195482;person_id|s:1:\"1\";'),('gr21qe23j94lge9elrh05a0b4ibesbpq','196.96.50.150',1667195482,_binary '__ci_last_regenerate|i:1667195482;'),('76cg0gkvf35vhn5994t91vc7o4t0iv0e','196.96.50.150',1667195482,_binary '__ci_last_regenerate|i:1667195482;'),('i476ui0euf57ptbk1rn9aj66l42ik0ia','196.96.50.150',1667195487,_binary '__ci_last_regenerate|i:1667195487;'),('q6k0929dium5gsab9qesa8sgdvjou5tn','196.96.50.150',1667195856,_binary '__ci_last_regenerate|i:1667195856;'),('ud3ar2s4d3if2msqa4l2kt468qdsir7i','196.96.50.150',1667195872,_binary '__ci_last_regenerate|i:1667195872;'),('81jccdvcdt23bl781bn26qir2b8lv84e','196.96.50.150',1667195884,_binary '__ci_last_regenerate|i:1667195884;'),('sks4823f39253amnpf0r95k4og3u2ouc','102.216.84.102',1667199513,_binary '__ci_last_regenerate|i:1667199215;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('sks4823f39253amnpf0r95k4og3u2ouc','196.216.95.67',1667199417,_binary '__ci_last_regenerate|i:1667199291;'),('sks4823f39253amnpf0r95k4og3u2ouc','196.216.95.96',1667199514,_binary '__ci_last_regenerate|i:1667199513;'),('omhmil7viq7fcl9uf9057sfskfove0a8','102.216.84.102',1667199547,_binary '__ci_last_regenerate|i:1667199541;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('27thn3r9hchalekqojkj0cs3failjb7f','196.216.95.59',1667199828,_binary '__ci_last_regenerate|i:1667199828;'),('27thn3r9hchalekqojkj0cs3failjb7f','102.216.84.102',1667199943,_binary '__ci_last_regenerate|i:1667199853;person_id|s:1:\"1\";menu_group|s:4:\"home\";'),('0jl1e02vmih6ue20g69mlagoasa4rp26','196.216.95.67',1667199964,_binary '__ci_last_regenerate|i:1667199964;'),('lc8k9dt5j02i4mdkgo5hsn4brqn22ecd','213.104.143.71',1667199966,_binary '__ci_last_regenerate|i:1667199966;'),('27thn3r9hchalekqojkj0cs3failjb7f','196.216.95.102',1667199986,_binary '__ci_last_regenerate|i:1667199986;'),('lml34nlc6br3v3v1mjqdsmsvdkpak1ff','196.216.95.67',1667199987,_binary '__ci_last_regenerate|i:1667199986;person_id|s:1:\"1\";'),('4kr11kh2o6t146gjrpps0ermcahnl8uv','196.216.95.67',1667199987,_binary '__ci_last_regenerate|i:1667199987;'),('ik48tv558dgcr7suk4eamksqt5cnlfbq','196.216.95.67',1667199987,_binary '__ci_last_regenerate|i:1667199987;'),('igbd1uu6o3ftr51tfi9n5r05q85mpg1r','196.216.95.67',1667200100,_binary '__ci_last_regenerate|i:1667200100;'),('c4r2oosk1t347rgbgtvi14qsfjg26e7f','196.216.95.96',1667200118,_binary '__ci_last_regenerate|i:1667200118;person_id|s:1:\"1\";'),('mirvb1ttd5aasihgb1cj8on27t8jr92e','196.216.95.96',1667200118,_binary '__ci_last_regenerate|i:1667200118;'),('pbb4pham32s3j1dbjk5qi904mdjsag9p','196.216.95.96',1667200119,_binary '__ci_last_regenerate|i:1667200119;'),('ttv8dlu5v98mdsomcmr4l25c61noj2tr','196.216.95.96',1667200125,_binary '__ci_last_regenerate|i:1667200125;'),('dplifudjqv6o9r06nfhrufs5jlvgiu2s','102.216.84.102',1667200149,_binary '__ci_last_regenerate|i:1667200149;'),('4qinn6bsollkugjv3bd22he6hjvskr0t','102.216.84.102',1667200167,_binary '__ci_last_regenerate|i:1667200167;'),('sef3dgbud9rujq0f16iu6lneo0lvmnbr','196.216.95.67',1667200189,_binary '__ci_last_regenerate|i:1667200189;'),('pbigalnjo9alfqt4n3o7onjpvao40oen','102.216.84.102',1667200239,_binary '__ci_last_regenerate|i:1667200238;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('ojn2qo0l1o2t33v9nkkoalmr2rn4vvoq','102.217.7.34',1667201074,_binary '__ci_last_regenerate|i:1667201074;'),('iu5046qo6n1hm2fjn4jb41oo1o5t685s','102.216.84.102',1667201426,_binary '__ci_last_regenerate|i:1667201215;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('iu5046qo6n1hm2fjn4jb41oo1o5t685s','196.216.95.59',1667201406,_binary '__ci_last_regenerate|i:1667201224;person_id|s:1:\"1\";menu_group|s:4:\"home\";'),('iu5046qo6n1hm2fjn4jb41oo1o5t685s','196.216.95.67',1667201661,_binary '__ci_last_regenerate|i:1667201375;person_id|s:1:\"1\";menu_group|s:6:\"office\";'),('iu5046qo6n1hm2fjn4jb41oo1o5t685s','196.216.95.96',1667201451,_binary '__ci_last_regenerate|i:1667201426;person_id|s:1:\"1\";menu_group|s:4:\"home\";'),('c1ktrhlli3drh02ee12lvclnhm5fa0to','102.216.84.102',1667202180,_binary '__ci_last_regenerate|i:1667201674;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('c1ktrhlli3drh02ee12lvclnhm5fa0to','196.216.95.67',1667201695,_binary '__ci_last_regenerate|i:1667201695;'),('c1ktrhlli3drh02ee12lvclnhm5fa0to','196.216.95.96',1667202180,_binary '__ci_last_regenerate|i:1667201719;person_id|s:1:\"1\";menu_group|s:4:\"home\";'),('c1ktrhlli3drh02ee12lvclnhm5fa0to','196.216.95.102',1667202241,_binary '__ci_last_regenerate|i:1667201731;'),('c1ktrhlli3drh02ee12lvclnhm5fa0to','196.216.95.59',1667202180,''),('kj36gurv3r53rab1j8jq1vdqgjof6bvt','196.216.95.67',1667202528,_binary '__ci_last_regenerate|i:1667202265;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;item_location|s:1:\"1\";sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('kj36gurv3r53rab1j8jq1vdqgjof6bvt','102.216.84.102',1667202490,_binary '__ci_last_regenerate|i:1667202417;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('kj36gurv3r53rab1j8jq1vdqgjof6bvt','196.216.95.96',1667202528,''),('kj36gurv3r53rab1j8jq1vdqgjof6bvt','196.216.95.59',1667202406,_binary '__ci_last_regenerate|i:1667202374;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('13e356r6hrvr15gqicukot2j4cc2skkt','196.216.95.102',1667202551,_binary '__ci_last_regenerate|i:1667202382;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('t7mg2s36kgjsb2a3h9vm60hdaiadaklj','197.136.0.4',1667202424,_binary '__ci_last_regenerate|i:1667202424;'),('b84updgkion8sefi44eqv2njrhh1ouh4','197.155.95.5',1667202426,_binary '__ci_last_regenerate|i:1667202424;'),('13e356r6hrvr15gqicukot2j4cc2skkt','196.216.95.96',1667202514,_binary '__ci_last_regenerate|i:1667202436;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('13e356r6hrvr15gqicukot2j4cc2skkt','102.216.84.102',1667202526,_binary '__ci_last_regenerate|i:1667202439;'),('kj36gurv3r53rab1j8jq1vdqgjof6bvt','196.216.95.102',1667202528,''),('13e356r6hrvr15gqicukot2j4cc2skkt','196.216.95.59',1667202562,_binary '__ci_last_regenerate|i:1667202555;'),('6siv8tpgh49ejimlke7lfhlhc5i8k5jc','196.216.95.67',1667202780,_binary '__ci_last_regenerate|i:1667202686;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:1;item_location|s:1:\"1\";sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;'),('6siv8tpgh49ejimlke7lfhlhc5i8k5jc','196.216.95.59',1667203029,_binary '__ci_last_regenerate|i:1667202724;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('6siv8tpgh49ejimlke7lfhlhc5i8k5jc','102.216.84.102',1667203001,_binary '__ci_last_regenerate|i:1667202748;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('6siv8tpgh49ejimlke7lfhlhc5i8k5jc','196.216.95.102',1667203029,_binary '__ci_last_regenerate|i:1667202849;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;sale_id|i:-1;sales_cart|a:0:{}sales_customer|i:-1;sales_mode|s:4:\"sale\";sales_location|s:1:\"1\";sales_payments|a:0:{}cash_mode|i:0;cash_rounding|i:0;item_location|s:1:\"1\";'),('vph17us8nuhpk12fn9jgftejmuag7eff','102.217.7.34',1667202987,_binary '__ci_last_regenerate|i:1667202987;'),('6siv8tpgh49ejimlke7lfhlhc5i8k5jc','196.216.95.96',1667203028,''),('ft0ap8vmhqifr098d1usoglliigqk1mn','102.216.84.102',1667203384,_binary '__ci_last_regenerate|i:1667203057;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('ft0ap8vmhqifr098d1usoglliigqk1mn','196.216.95.102',1667203500,_binary '__ci_last_regenerate|i:1667203499;'),('ft0ap8vmhqifr098d1usoglliigqk1mn','196.216.95.59',1667203233,_binary '__ci_last_regenerate|i:1667203212;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('ft0ap8vmhqifr098d1usoglliigqk1mn','196.216.95.96',1667203385,''),('s8ibbrf1o22crnd3dm39hrn4gvs2j16e','102.216.84.102',1667203870,_binary '__ci_last_regenerate|i:1667203507;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('s8ibbrf1o22crnd3dm39hrn4gvs2j16e','196.216.95.67',1667203790,''),('s8ibbrf1o22crnd3dm39hrn4gvs2j16e','196.216.95.102',1667203870,''),('13e356r6hrvr15gqicukot2j4cc2skkt','196.216.95.67',1667203623,_binary '__ci_last_regenerate|i:1667203622;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('s8ibbrf1o22crnd3dm39hrn4gvs2j16e','196.216.95.96',1667203733,_binary '__ci_last_regenerate|i:1667203681;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('s8ibbrf1o22crnd3dm39hrn4gvs2j16e','196.216.95.59',1667203854,_binary '__ci_last_regenerate|i:1667203825;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('8cviv2v5i0som25k61kvam53h0qh99dh','102.216.84.102',1667203680,_binary '__ci_last_regenerate|i:1667203652;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('8cviv2v5i0som25k61kvam53h0qh99dh','196.216.95.102',1667203692,_binary '__ci_last_regenerate|i:1667203692;'),('8cviv2v5i0som25k61kvam53h0qh99dh','196.216.95.67',1667203835,_binary '__ci_last_regenerate|i:1667203705;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('8cviv2v5i0som25k61kvam53h0qh99dh','196.216.95.59',1667203730,_binary '__ci_last_regenerate|i:1667203730;'),('838c1dfofqgp5nur9noaafp7vhcl22nq','196.216.95.59',1667203932,_binary '__ci_last_regenerate|i:1667203932;'),('838c1dfofqgp5nur9noaafp7vhcl22nq','196.216.95.96',1667203967,_binary '__ci_last_regenerate|i:1667203963;person_id|s:1:\"2\";menu_group|s:4:\"home\";'),('838c1dfofqgp5nur9noaafp7vhcl22nq','196.216.95.102',1667203995,_binary '__ci_last_regenerate|i:1667203991;'),('838c1dfofqgp5nur9noaafp7vhcl22nq','196.216.95.67',1667204008,_binary '__ci_last_regenerate|i:1667203995;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('838c1dfofqgp5nur9noaafp7vhcl22nq','102.216.84.102',1667204052,_binary '__ci_last_regenerate|i:1667204009;person_id|s:1:\"2\";menu_group|s:4:\"home\";allow_temp_items|i:0;item_location|s:1:\"1\";'),('3u76s9nde40kvddljkg77rjmjfe98947','197.232.61.218',1667205160,_binary '__ci_last_regenerate|i:1667205074;'),('7c598b9c6387397f1a153a0125c0ca372164f326','197.232.61.218',1667206603,_binary '__ci_last_regenerate|i:1667206603;'),('e7db65b75ef66b92ac5b00a3c8f35813eb1e3732','197.232.61.218',1667206603,_binary '__ci_last_regenerate|i:1667206603;'),('fc002848582d8b70f9dd91776281b1b9b6b92a98','197.232.18.74',1667275534,_binary '__ci_last_regenerate|i:1667275534;');
/*!40000 ALTER TABLE `ospos_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_stock_locations`
--

DROP TABLE IF EXISTS `ospos_stock_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_stock_locations` (
  `location_id` int(11) NOT NULL AUTO_INCREMENT,
  `location_name` varchar(255) DEFAULT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`location_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_stock_locations`
--

LOCK TABLES `ospos_stock_locations` WRITE;
/*!40000 ALTER TABLE `ospos_stock_locations` DISABLE KEYS */;
INSERT INTO `ospos_stock_locations` VALUES (1,'Kathangaita',0);
/*!40000 ALTER TABLE `ospos_stock_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_suppliers`
--

DROP TABLE IF EXISTS `ospos_suppliers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_suppliers` (
  `person_id` int(10) NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `agency_name` varchar(255) NOT NULL,
  `account_number` varchar(255) DEFAULT NULL,
  `tax_id` varchar(32) NOT NULL DEFAULT '',
  `deleted` int(1) NOT NULL DEFAULT '0',
  `category` tinyint(4) NOT NULL,
  UNIQUE KEY `account_number` (`account_number`),
  KEY `person_id` (`person_id`),
  CONSTRAINT `ospos_suppliers_ibfk_1` FOREIGN KEY (`person_id`) REFERENCES `ospos_people` (`person_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_suppliers`
--

LOCK TABLES `ospos_suppliers` WRITE;
/*!40000 ALTER TABLE `ospos_suppliers` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_suppliers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_tax_categories`
--

DROP TABLE IF EXISTS `ospos_tax_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_tax_categories` (
  `tax_category_id` int(10) NOT NULL AUTO_INCREMENT,
  `tax_category` varchar(32) NOT NULL,
  `tax_group_sequence` tinyint(2) NOT NULL,
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_tax_categories`
--

LOCK TABLES `ospos_tax_categories` WRITE;
/*!40000 ALTER TABLE `ospos_tax_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_tax_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_tax_codes`
--

DROP TABLE IF EXISTS `ospos_tax_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_tax_codes` (
  `tax_code_id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_code` varchar(32) NOT NULL,
  `tax_code_name` varchar(255) NOT NULL DEFAULT '',
  `city` varchar(255) NOT NULL DEFAULT '',
  `state` varchar(255) NOT NULL DEFAULT '',
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_code_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_tax_codes`
--

LOCK TABLES `ospos_tax_codes` WRITE;
/*!40000 ALTER TABLE `ospos_tax_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_tax_codes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_tax_jurisdictions`
--

DROP TABLE IF EXISTS `ospos_tax_jurisdictions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_tax_jurisdictions` (
  `jurisdiction_id` int(11) NOT NULL AUTO_INCREMENT,
  `jurisdiction_name` varchar(255) DEFAULT NULL,
  `tax_group` varchar(32) NOT NULL,
  `tax_type` smallint(2) NOT NULL,
  `reporting_authority` varchar(255) DEFAULT NULL,
  `tax_group_sequence` tinyint(2) NOT NULL DEFAULT '0',
  `cascade_sequence` tinyint(2) NOT NULL DEFAULT '0',
  `deleted` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`jurisdiction_id`),
  UNIQUE KEY `tax_jurisdictions_uq1` (`tax_group`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_tax_jurisdictions`
--

LOCK TABLES `ospos_tax_jurisdictions` WRITE;
/*!40000 ALTER TABLE `ospos_tax_jurisdictions` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_tax_jurisdictions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ospos_tax_rates`
--

DROP TABLE IF EXISTS `ospos_tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ospos_tax_rates` (
  `tax_rate_id` int(11) NOT NULL AUTO_INCREMENT,
  `rate_tax_code_id` int(11) NOT NULL,
  `rate_tax_category_id` int(10) NOT NULL,
  `rate_jurisdiction_id` int(11) NOT NULL,
  `tax_rate` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax_rounding_code` tinyint(2) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tax_rate_id`),
  KEY `rate_tax_category_id` (`rate_tax_category_id`),
  KEY `rate_tax_code_id` (`rate_tax_code_id`),
  KEY `rate_jurisdiction_id` (`rate_jurisdiction_id`),
  CONSTRAINT `ospos_tax_rates_ibfk_1` FOREIGN KEY (`rate_tax_category_id`) REFERENCES `ospos_tax_categories` (`tax_category_id`),
  CONSTRAINT `ospos_tax_rates_ibfk_2` FOREIGN KEY (`rate_tax_code_id`) REFERENCES `ospos_tax_codes` (`tax_code_id`),
  CONSTRAINT `ospos_tax_rates_ibfk_3` FOREIGN KEY (`rate_jurisdiction_id`) REFERENCES `ospos_tax_jurisdictions` (`jurisdiction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ospos_tax_rates`
--

LOCK TABLES `ospos_tax_rates` WRITE;
/*!40000 ALTER TABLE `ospos_tax_rates` DISABLE KEYS */;
/*!40000 ALTER TABLE `ospos_tax_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'linuxele_new'
--

--
-- Dumping routines for database 'linuxele_new'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2022-11-04  2:49:48
